/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.modelbinder;

import java.util.Arrays;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.Utils;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.NotFoundException;

public class BinderGenerator extends Generator{
	
	private ComposerHelper composerHelper;
	
	private Binder binderAnnotation;
	
	private JClassType watchedModelType;
	
	private JClassType modelToBindType;
	
	private List<String> fieldsToIgnore;
	
	private JClassTypeHelper typeHelper;
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		
		try {

			JClassType type = context.getTypeOracle().getType(typeName);
			
			this.composerHelper 	= new ComposerHelper(context, logger, type.getPackage().getName(), type.getSimpleSourceName()+"_Generated");
			this.typeHelper			= new JClassTypeHelper(type);
			this.composerHelper.setSuperClass(typeName);
			
			this.binderAnnotation 	= type.getAnnotation(Binder.class);
			
			if (binderAnnotation==null){
				return typeName;
			}
			
			watchedModelType = context.getTypeOracle().getType(binderAnnotation.watchedModel().getCanonicalName());
			modelToBindType  = context.getTypeOracle().getType(binderAnnotation.bindedModel().getCanonicalName());
			fieldsToIgnore   = Arrays.asList(binderAnnotation.watchedModelIgnoredFields());
			
			addBindMethod();
			
			addInitializeWatchedModel();
			
			addOnInstantiationMethod();
			
			this.composerHelper.commit();
			
			
		} catch (NotFoundException e) {

			e.printStackTrace();
		}
		
		
		
		
		return this.composerHelper.getCreatedClassName();
	}


	private void addBindMethod() {
		
		JClassTypeHelper helper = new JClassTypeHelper(watchedModelType);
		
		Method bindMethod = new Method(Visibility.PUBLIC, void.class, "bind");
		bindMethod.addParameter(bindMethod.new Parameter(binderAnnotation.watchedModel(), "watchedModel"));
		bindMethod.addParameter(bindMethod.new Parameter(binderAnnotation.bindedModel(), "modelToBind"));
		bindMethod.isOverride(true);
		
		if (typeHelper.containsMethod(bindMethod.getName())) bindMethod.getBody().append("super."+bindMethod.call("watchedModel","modelToBind"));

		for(JField field : helper.getAllFields()){
			
			if (fieldsToIgnore.contains(field.getName())==false){
			boolean isBoolean = field.getType().getQualifiedSourceName().equals(boolean.class.getCanonicalName()) || field.getType().getQualifiedSourceName().equals(Boolean.class.getCanonicalName()); 

			String getter = Utils.getGetterMethodByFieldName(field.getName(), isBoolean);
			String setter = Utils.getSetterMethodByFieldName(field.getName());
			
			bindMethod.getBody().append("modelToBind."+setter+"(watchedModel."+getter+"())");
			}
		
		}
		
		composerHelper.addMethod(bindMethod);
	}

	private void addInitializeWatchedModel() {
		
		JClassTypeHelper helper = new JClassTypeHelper(watchedModelType);
		
		Method initializeMethod = new Method(Visibility.PUBLIC, void.class, "initializeWatchedModel");
		initializeMethod.addParameter(initializeMethod.new Parameter(binderAnnotation.watchedModel(), "watchedModel"));
		initializeMethod.addParameter(initializeMethod.new Parameter(binderAnnotation.bindedModel(), "modelToBind"));
		initializeMethod.isOverride(true);
		
		if (typeHelper.containsMethod(initializeMethod.getName())) initializeMethod.getBody().append("super."+initializeMethod.call("watchedModel","modelToBind"));
		
		for(JField field : helper.getAllFields()){
			if (fieldsToIgnore.contains(field.getName())==false){
			boolean isBoolean = field.getType().getQualifiedSourceName().equals(boolean.class.getCanonicalName()) || field.getType().getQualifiedSourceName().equals(Boolean.class.getCanonicalName());
			
			String getter = Utils.getGetterMethodByFieldName(field.getName(), isBoolean);
			String setter = Utils.getSetterMethodByFieldName(field.getName());
			
			initializeMethod.getBody().append("watchedModel."+setter+"(modelToBind."+getter+"())");
			}
		}
		
		composerHelper.addMethod(initializeMethod);
		
		
	}

	
	private void addOnInstantiationMethod(){
		
		Method onInstantiationMethod = new Method(Visibility.PUBLIC,void.class,"onInstantiation");

		onInstantiationMethod.addParameter(onInstantiationMethod.new Parameter(binderAnnotation.watchedModel(), "watchedModel"));
		onInstantiationMethod.addParameter(onInstantiationMethod.new Parameter(binderAnnotation.bindedModel(), "modelToBind"));
		onInstantiationMethod.isOverride(true);
		
		if (typeHelper.containsMethod(onInstantiationMethod.getName())) onInstantiationMethod.getBody().append("super."+onInstantiationMethod.call("watchedModel","modelToBind"));
		
		composerHelper.addMethod(onInstantiationMethod);
	}



}
