/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.component;

import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.request.IGetEditConfigurationPanelsByProjectInstance;
import com.ebmwebsourcing.geasytools.webeditor.api.components.response.IGetEditConfigurationPanelsByProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.component.IDefaultRequestComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IComponentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestEvent;

public class DefaultRequestComponentHandler implements IDefaultRequestComponentHandler{
	
	private IComponentManager componentManager;
	
	public DefaultRequestComponentHandler(IComponentManager componentManager) {
		this.componentManager = componentManager;
	}
	
	@Override
	public IComponentManager getComponentManager() {
		return componentManager;
	}

	@Override
	public void onRequest(IRequestEvent event) {
		
		
		if (event.getRequest() instanceof IGetEditConfigurationPanelsByProjectInstance){
			
			IGetEditConfigurationPanelsByProjectInstance req = (IGetEditConfigurationPanelsByProjectInstance) event.getRequest();
			
			IGetEditConfigurationPanelsByProjectInstanceResponseHandler res = (IGetEditConfigurationPanelsByProjectInstanceResponseHandler) event.getResponseHandler();
			
			List<IEditConfigurationPanel> panels = componentManager.getFrontController().getRegistry().getEditConfigurationPanelsByProjectInstance(req.getProjectInstance());
			
			//if panels ==null => means that we are invoking it for the first time
			//=> load panels from plugin and register them in registry for next invoke
			if (panels==null){
				
				panels = componentManager.getFrontController().getRegistry().getProjectPlugin(req.getProjectInstance().getProjectType()).getEditConfigurationPanels(req.getProjectInstance());
				componentManager.getFrontController().getRegistry().registerEditConfigurationPanels(req.getProjectInstance(), panels);
			
			}
			
			res.receiveResponse(panels);
			
		}
		
		
		
	}

}
