/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IPanelChangeEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IContentPanelPlaceHolderHandler;
import com.google.gwt.event.shared.GwtEvent;

public class PanelChangeEvent extends GwtEvent<IContentPanelPlaceHolderHandler> implements IPanelChangeEvent{
	
	private IContentPanelComponent contentPanelComponent;
	
	public static Type<IContentPanelPlaceHolderHandler> TYPE = new Type<IContentPanelPlaceHolderHandler>();
	
	public PanelChangeEvent(IContentPanelComponent contentPanelComponent) {
		this.contentPanelComponent = contentPanelComponent;
	}
	


	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IContentPanelPlaceHolderHandler> getAssociatedType() {
		return TYPE;
	}



	@Override
	protected void dispatch(IContentPanelPlaceHolderHandler handler) {
		handler.onPanelChange(this);
	}


	@Override
	public IContentPanelComponent getSelectedPanel() {
		return contentPanelComponent;
	}



}
