/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxyData;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.common.AbstractBPMNDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ManualTask;

public class ManualTaskDragProxy extends AbstractBPMNDragProxy{
	
	
	public ManualTaskDragProxy(IUIPanel uipanel) {
		super(uipanel);
		

		
		
	}

	public IHasDragProxyData getData() {
		
		return null;
	}


	@Override
	protected String getDescription() {
		return "A Manual Task is a Task that is expected to be performed without the aid of any business process execution engine or any application";
	}

	@Override
	protected String getBigIcon() {
		return "images/ico/bpmn/activity/task_manual.png";
	}

	@Override
	protected String getLabel() {
		return "Manual task";
	}



	public Class<? extends IUIElement> getIUIElementType() {
		return ManualTask.class;
	}

	@Override
	protected String getSmallIcon() {
		return "images/ico/bpmn/activity/task_manual16x16.png";	
	}



	

}
