/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.HandlerRegistration;

public class TaskMenuDragProxy extends TaskDragProxy implements IHasMenuDragProxy{
	
	private LinkedHashSet<IHasMenuDragProxy> subDragProxies;
	
	private IHasDragProxyContextualMenu subject;
	
	public TaskMenuDragProxy(IUIPanel uipanel) {
		super(uipanel);
		this.subDragProxies = new LinkedHashSet<IHasMenuDragProxy>();
		this.setPixelSize(17, 17);

		
		LinkedHashSet<IHasMenuDragProxy> result = new LinkedHashSet<IHasMenuDragProxy>();
		
		CallActivityMenuDragProxy cadp = new CallActivityMenuDragProxy(uipanel);
		cadp.setLabelVisible(false);
		cadp.setSmallIcon(true);
		result.add(cadp);		
		
		ServiceTaskMenuDragProxy d1 = new ServiceTaskMenuDragProxy(uipanel);
		d1.setLabelVisible(false);
		d1.setSmallIcon(true);
		result.add(d1);
		
		SendTaskMenuDragProxy d2 = new SendTaskMenuDragProxy(uipanel);
		d2.setLabelVisible(false);
		d2.setSmallIcon(true);
		result.add(d2);
		
		ReceiveTaskMenuDragProxy d3 = new ReceiveTaskMenuDragProxy(uipanel);
		d3.setLabelVisible(false);
		d3.setSmallIcon(true);
		result.add(d3);
		
		ManualTaskMenuDragProxy d4 = new ManualTaskMenuDragProxy(uipanel);
		d4.setLabelVisible(false);
		d4.setSmallIcon(true);		
		result.add(d4);
		
		UserTaskMenuDragProxy d5 = new UserTaskMenuDragProxy(uipanel);
		d5.setLabelVisible(false);
		d5.setSmallIcon(true);		
		result.add(d5);		
		
		ScriptTaskMenuDragProxy d6 = new ScriptTaskMenuDragProxy(uipanel);
		d6.setLabelVisible(false);
		d6.setSmallIcon(true);		
		result.add(d6);		
		
		
		BusinessRuleTaskMenuDragProxy d7 = new BusinessRuleTaskMenuDragProxy(uipanel);
		d7.setLabelVisible(false);
		d7.setSmallIcon(true);		
		result.add(d7);
		
		this.subDragProxies.addAll(result);
		
	
	}


	
	@Override
	public IHasDragProxyContextualMenu getContextualMenuSubject() {
		return subject;
	}

	@Override
	public void setContextualMenuSubject(IHasDragProxyContextualMenu subject) {
		this.subject = subject;
	}

	@Override
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		return subDragProxies;
	}

	@Override
	public float getHeight() {
		return this.getOffsetHeight();
	}

	@Override
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public float getWidth() {
		return this.getOffsetWidth();
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}


	

}
