/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor.Widget;

@Editor
public class CommonEditorModel implements IEditorModel{
	
	@Widget(label="Name", order=0)
	private String name;
	
	@Widget(label="Documentation",order=1)
	private String documentation;

	
	public CommonEditorModel() {
	
	}
	
	
	public void copy(Object object) {
		
		CommonEditorModel otc 	= (CommonEditorModel) object;
		
		this.name 				= otc.getName();
		this.documentation 		= otc.getDocumentation();
		
	}

	
	
	public String getName() {
		return name;
	}
	
	public String getDocumentation() {
		return documentation;
	}
	
	public void setDocumentation(String documentation) {
		this.documentation = documentation;
	}
	
	public void setName(String name) {
		this.name = name;
	}



	
}
