/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.activity;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.ModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor.Widget;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonTemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.activity.binder.SendTaskBinder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget.MessageListInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget.OperationListInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;

@Editor(template=CommonTemplate.class)
@ModelBinder(binder = SendTaskBinder.class)
public class SendTaskEditorModel extends DefaultTaskEditorModel {

	@Widget(label="Message",instantiationHandler=MessageListInstantiationHandler.class)
	private IMessageBean message;
	
	@Widget(label="Operation",instantiationHandler=OperationListInstantiationHandler.class)
	private IOperationBean operation;
	
	public IMessageBean getMessage() {
		return message;
	}
	
	public void setMessage(IMessageBean message) {
		this.message = message;
	}
	
	public IOperationBean getOperation() {
		return operation;
	}
	
	public void setOperation(IOperationBean operation) {
		this.operation = operation;
	}
	
}
