/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.ModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor.Widget;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.binder.DataAssociationBinder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.template.DataAssociationTemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget.ItemDefinitionListInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;

@Editor(template=DataAssociationTemplate.class)
@ModelBinder(binder = DataAssociationBinder.class)
public class DataAssociationEditorModel extends CommonEditorModel{

	@Widget(label="From",order=2)
	private String from;
	
	@Widget(label="To",order=3)
	private String to;
	
	@Widget(order=4,label = "Flow Node Item",instantiationHandler=ItemDefinitionListInstantiationHandler.class)
	private IItemDefinitionBean itemDef;
	
	public String getFrom() {
		return from;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public String getTo() {
		return to;
	}

	public void setTo(String to) {
		this.to = to;
	}

	public IItemDefinitionBean getItemDef() {
		return itemDef;
	}

	public void setItemDef(IItemDefinitionBean itemDef) {
		this.itemDef = itemDef;
	}

}