/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data;


import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IMethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.ISetterCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Message;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.MessageVisibleKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNEdge;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;

/**
 * @author nfleury
 */
public class MessageObservableHandler implements IObservableHandler{

	@Override
	public void onMethodCalled(IMethodCalledEvent event) {

		
	}

	@Override
	public void onSetterCalled(final ISetterCalledEvent event) {
				Field field = event.getField();
		
		if (field.getName().equals("initiating")){
			
			MessageEditorModel editorModel = (MessageEditorModel) field.getEnclosingObject();
		
				
				IHasLookupProxy lookupProxy = (IHasLookupProxy) editorModel;
				
				Message message = (Message) lookupProxy.lookup(Message.class);
				
				if (message!=null){
					
					BPMNShape shape = (BPMNShape) message.getDiagramElement();
					
					BPMNEdge edge = (BPMNEdge) shape.getIncomingEdges().iterator().next();
					
					if (edge!=null){
						
						if ((Boolean)event.getField().getValue()){
							edge.setMessageVisibleKind(MessageVisibleKind.initiating);
						}else{
							edge.setMessageVisibleKind(MessageVisibleKind.non_initiating);
						}
						
					}
					
				}
				
			
		}
		

		
	}

}
