/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.DefaultParticipantEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder.DefaultParticipants;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;

@Binder(bindedModel = CollaborationBean.class,watchedModel=DefaultParticipantEditorModel.class,watchedModelIgnoredFields={"initiating","interfaces","minimumMultiplicity","maximumMultiplicity","name","documentation"})
public abstract class DefaultParticipantBinder implements IBinder<DefaultParticipantEditorModel,CollaborationBean> {

	private IParticipantBean participant;
	private boolean initialized;

	@Override
	public void initializeWatchedModel(
			DefaultParticipantEditorModel watchedModel,
			CollaborationBean modelToBind) {
		this.initialized = false;

		if(!modelToBind.getParticipants().isEmpty()) {
			for(IParticipantBean p : modelToBind.getParticipants()) {
				if(p.getProcess()!=null && !p.getProcess().getFlowNodes().isEmpty()) {
					this.participant = p;
					break;
				}
			}
		}
		modelToBind.addParticipant(participant);
		DefaultParticipants.setDefaultParticipant(modelToBind, participant);

		watchedModel.setName(participant.getName());
		watchedModel.setDocumentation(participant.getDocumentation());
		watchedModel.setInterfaces(participant.getInterfaces());

		this.initialized = true;
	}

	@Override
	public void onInstantiation(DefaultParticipantEditorModel watchedModel,
			CollaborationBean modelToBind) {
		this.participant = new ParticipantBean();
		this.initialized = false;
	}

	@Override
	public void bind(DefaultParticipantEditorModel watchedModel,
			CollaborationBean modelToBind) {
		if(this.initialized) {
			participant.setDocumentation(watchedModel.getDocumentation());
			participant.setInterfaces(watchedModel.getInterfaces());
			participant.setMaximumMultiplicity(watchedModel.getMaximumMultiplicity());
			participant.setMinimumMultiplicity(watchedModel.getMinimumMultiplicity());
			participant.setName(watchedModel.getName());
		}
	}

}
