/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IHasEditor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IWidgetInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.ListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.BeforeDisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.CoreBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;

public class SequenceFlowListInstantiationHandler implements IWidgetInstantiationHandler<ListUIField<ISequenceFlowBean>>{
	
	private IHasEditor activityEditorModel;
	
	@Override
	public ListUIField<ISequenceFlowBean> instantiate() {
		
		final ListUIField<ISequenceFlowBean> list = new ListUIField<ISequenceFlowBean>(null);
		
		list.addUIFieldHandler(new IUIFieldHandler() {
			
			@Override
			public void onDisplay(DisplayEvent event) {
				
				IHasLookupProxy lookupProxy = (IHasLookupProxy) activityEditorModel;
				
				IConnectableElement activity = (IConnectableElement) lookupProxy.lookup(CoreBPMNElement.class);
				
				ArrayList<ISequenceFlowBean> seqFlows = new ArrayList<ISequenceFlowBean>();
				
				for(IConnector connector:activity.getOutgoingConnectors()){
					
					if (connector instanceof SequenceFlow){
						
						SequenceFlow sf = (SequenceFlow) connector;
						seqFlows.add((ISequenceFlowBean)sf.getDiagramElement().getModelElement());
						
					}
					
				}
				
				list.setOptions(seqFlows);
				
			}

			@Override
			public void onBeforeDiplay(BeforeDisplayEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
		return list;
	}

	
	@Override
	public void setDataProvider(Object dataProvider) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setEditorModel(IHasEditor model) {
		this.activityEditorModel = model;
	}


}
