/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IEdge;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.syntax.SyntaxModelBuilder;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.IArtifactBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography.ChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography.ChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.artifact.ArtifactBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.artifact.AssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;

public class ChoreographyBuilder extends SyntaxModelBuilder<ChoreographyBean>{
	
	public ChoreographyBuilder() {
		this.register(new ChoreographyTaskBuilder());
	}
	
	@Override
	public ChoreographyBean getSyntaxModel() {
		
		ChoreographyBean choreography = (ChoreographyBean) getMainDiagramElement().getModelElement();
		
		//ADD ALL PARTICIPANTS
		Set<ParticipantBean> participants = this.getAll(ParticipantBean.class,true);
		for(ParticipantBean p:participants){

			choreography.addParticipant(p);
			
		}
		
		//GET ALL CHOREOTASKS 
		Set<ChoreographyTaskBean> choreoTasks = this.getAll(ChoreographyTaskBean.class, false);
		process(choreoTasks);
		
		//ADD ALL FLOW ELEMENTS
		choreography.cleanFlowNodes();
		
		Set<FlowElementBean> flowElements = this.getAll(FlowElementBean.class, false);
		
		for(FlowElementBean flowElement:flowElements){
			
			choreography.addFlowElement(flowElement);
			
		}
		
		//SET SEQUENCE FLOWS SOURCE/TARGET
		//grab all sequence flows
		HashMap<IDiagramElement,SequenceFlowBean> sequenceFlows = (HashMap<IDiagramElement, SequenceFlowBean>) this.getEdges(SequenceFlowBean.class);
		
		for(IDiagramElement di:sequenceFlows.keySet()){
			
			SequenceFlowBean s = sequenceFlows.get(di);
			s.setSourceNode((IFlowElementBean) ((IEdge)di).getSource().getModelElement());
			s.setTargetNode((IFlowElementBean) ((IEdge)di).getTarget().getModelElement());
		}
		
		////////////MESSAGE
		choreography.getMessages().clear();
		
		Set<MessageBean> messages = this.getAll(MessageBean.class, false);

		for(MessageBean m:messages){
			choreography.addMessage(m);
		}
		
		//////////////////ARTIFACTS
		
		//GET ALL MESSAGE ASSOCIATIONS
		Map<IDiagramElement,AssociationBean> associations = this.getEdges(AssociationBean.class);
		process(associations);
		
		choreography.getArtifacts().clear();
		
		//add associations to choreography
		for(AssociationBean a:associations.values()){
			choreography.addArtifact(a);
		}

		//GET ALL ARTIFACTS => add them to choreography
		Set<ArtifactBean> artifacts = this.getAll(ArtifactBean.class, false);
		
		for(IArtifactBean a:artifacts){
			choreography.addArtifact(a);
		}
		
		return choreography;
		
	}
	
	private void process(Set<ChoreographyTaskBean> choreoTasks){
		
		//assign message flow to initiating participant
		for(ChoreographyTaskBean ct:choreoTasks){
			
			ct.setInitiatingMessageFlow(null);

			if (ct.getInitiatingParticipant()!=null){
				
				IParticipantBean source = ct.getInitiatingParticipant();
				IParticipantBean target = getNonInitiatingParticipant(ct);
				
				MessageFlowBean initiatingMessageFlow = new MessageFlowBean("MsgFlow_"+source.getId()+"_"+target.getId());
				initiatingMessageFlow.setSource(source);
				initiatingMessageFlow.setTarget(target);

				ct.setInitiatingMessageFlow(initiatingMessageFlow);
			}
			
		}
		
	}
	
	/**
	 * Returns non initiating participant
	 * @param ct
	 * @return
	 */
	private IParticipantBean getNonInitiatingParticipant(ChoreographyTaskBean ct){
		//FIXME:WORKS ONLY WITH 2 PARTICIPANTS
		for(IParticipantBean p:ct.getParticipants()){
			if (p!=ct.getInitiatingParticipant()){
				return p;
			}
		}
		return null;
	}
	
	private void process(Map<IDiagramElement,AssociationBean> associations){
		
		//assign source / target
		for(IDiagramElement el:associations.keySet()){
			
			IEdge edge = (IEdge) el;
			
			AssociationBean assoc = associations.get(el);
			assoc.setSource((IBaseElementBean) edge.getSource().getModelElement());
			assoc.setTarget((IBaseElementBean) edge.getTarget().getModelElement());
			
		}
		
		//assign returning message flows and messages
		for(IDiagramElement di:associations.keySet()){
			
			IEdge edge = (IEdge) di;
			
			if (edge.getSource().getModelElement() instanceof IParticipantBean
				&& edge.getTarget().getModelElement() instanceof IMessageBean){
				
				IParticipantBean sourceParticipant 	= (IParticipantBean) edge.getSource().getModelElement();
				IMessageBean targetMessage 			= (IMessageBean) edge.getTarget().getModelElement();
				
				ChoreographyTaskBean choreoTask = (ChoreographyTaskBean) edge.getSource().getOwningElement().getModelElement();
				
				//if current source is the initiating Participant => assign message 
				//to initiating message flow
				if (sourceParticipant==choreoTask.getInitiatingParticipant()){
					
					choreoTask.getInitiatingMessageFlow().setMessage(targetMessage);
				
				}else{
				//if its not the initiating participant then add a return message flow with message	
				
					if (choreoTask.getInitiatingParticipant()!=null){
						
						MessageFlowBean returnMessageFlow = new MessageFlowBean("MsgFlow_"+sourceParticipant.getId()+"_"+choreoTask.getInitiatingParticipant().getId());
						
						returnMessageFlow.setMessage(targetMessage);
						returnMessageFlow.setSource(sourceParticipant);
						returnMessageFlow.setTarget(choreoTask.getInitiatingParticipant());
						
						choreoTask.setReturnMessageFlow(returnMessageFlow);
						
					}
					
				}
				
			}
			
		}
		
		
	}
	
	@Override
	public Class<? extends ChoreographyBean> getSyntaxModelType() {
		return ChoreographyBean.class;
	}

}
