/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.palette;

import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.DiagramElementViewInstantiationHandlerRegistry;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.PaletteGroup;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.choreography.ChoreographyParticipantDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.choreography.ChoreographyTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.ChoreographyTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.ChoreographyTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.PoolInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.PoolInstantiationHandler.ParticipantType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography.ChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;

public class ChoreographyPalette extends ProcessPalette{
	
	protected PaletteGroup choreographyGroup; 
	
	protected ChoreographyTaskDragProxy choreographyTaskDragProxy;
	protected ChoreographyParticipantDragProxy choreographyParticipantDragProxy;
	
	
	public ChoreographyPalette(IUIPanel uipanel) {
		super(uipanel);

		this.removeGroup(containersGroup);
		this.removeGroup(activitiesGroup);
		this.removeGroup(dataGroup);
		
		this.connectorsGroup.removeElement(this.mfdp);
		this.connectorsGroup.removeElement(this.dadp);
		
		choreographyTaskDragProxy 			= new ChoreographyTaskDragProxy(uipanel);
		choreographyParticipantDragProxy	= new ChoreographyParticipantDragProxy(uipanel);
		
		choreographyGroup = new PaletteGroup("Choreography");
		
		choreographyGroup.addElement(choreographyTaskDragProxy);
		choreographyGroup.addElement(choreographyParticipantDragProxy);
		
		this.prependGroup(choreographyGroup);
	}
	
	@Override
	protected void init() {
		super.init();
		
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ChoreographyTask.class, ChoreographyTaskBean.class, new ChoreographyTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(Participant.class, ParticipantBean.class, new PoolInstantiationHandler(ParticipantType.Choreography));
		
	}

}
