/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementViewInstantiationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;
import com.google.gwt.core.client.GWT;

public class ChoreographyTaskInstantiationHandler implements IDiagramElementViewInstantiationHandler<ChoreographyTask>{

	@Override
	public ChoreographyTask createElement(IModelElement syntaxModel,
			IDiagramView diagramView) {
		
		String id = IdGenerator.createUniqueId();
		
		if (syntaxModel!=null) id 	= syntaxModel.getId();
		
		ChoreographyTask ct 		= new ChoreographyTask((ChoreographyPanel)diagramView, id);
		
//		BPMNShape ctShape			= (BPMNShape) ct.getDiagramElement();
		
//		PoolInstantiationHandler pih = new PoolInstantiationHandler(ParticipantType.Choreography);

		//participant 1
//		Participant p1 = (Participant) pih.instantiate(new ChoreographyParticipantDragProxy(diagramView),diagramView);
		
//		BPMNShape p1Shape = GWT.create(BPMNShape.class);
//		p1Shape.setParticipantBandKind(ParticipantBandKind.top_initiating);
//		p1Shape.setY(1);
//		p1Shape.setOwningElement(ctShape);
//		p1Shape.setModelElement(new ParticipantBean());
//		ctShape.addDiagramElement(p1Shape);
//		diagramView.addUIElement(p1);
//		ct.addUIElement(p1);
				
		//participant 2
//		Participant p2 = (Participant) pih.instantiate(new ChoreographyParticipantDragProxy(diagramView),diagramView);
		
//		BPMNShape p2Shape = GWT.create(BPMNShape.class);
//		p2Shape.setParticipantBandKind(ParticipantBandKind.bottom_non_initiating);
//		p2Shape.setY(130);
//		p2Shape.setModelElement(new ParticipantBean());
//		p2Shape.setOwningElement(ctShape);
//		ctShape.addDiagramElement(p2Shape);
//		diagramView.addUIElement(p2);
//		ct.addUIElement(p2);
		


		

		
		return ct;
	}

	@Override
	public ChoreographyTask instantiate(IDiagramElement diagramElement,
			IDiagramView diagramView) {
		return createElement(diagramElement.getModelElement(), diagramView);
	}

	@Override
	public ChoreographyTask instantiate(IHasDragProxy draggableProxyData,
			IDiagramView diagramView) {

		return createElement(null, diagramView);
	}
	
	


}
