/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.data.MessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ConnectableFlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ContextualMenuHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectionMode;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.google.gwt.core.client.GWT;

public class Participant extends ConnectableFlowElement implements IHasDragProxyContextualMenu{

	protected Rectangle rectangle;
	
	public static final int  DEFAULT_HEIGHT = 15;
	public static final int  DEFAULT_WIDTH  = 150;
	
	protected Rectangle linearPath;
	
	private ParticipantLevel level;
	
	private boolean initiating;
	
	private ConnectableElementDefaultHandlers defaultHandlers;
	
	public Participant(ChoreographyPanel definitionPanel, String id) {
		super(definitionPanel, id,ConnectionMode.ALL);
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(75, 7, "");
		this.linearPath = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, DEFAULT_WIDTH, 1);
		
		this.getGroup().appendChild(label);
		this.getGroup().appendChild(linearPath);
		linearPath.setY(DEFAULT_HEIGHT);
		linearPath.setVisible(false);
		
		//Add contextual menu ability
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
		
	}
	
	@Override
	public void onStart(IDragStartEvent event) {
		super.onStart(event);
		this.setLevel(ParticipantLevel.MIDDLE);
	}
	
	
	public void setInitiating(boolean b){
		if (b){
			this.rectangle.setFillColour("#FFFFFF");
		}else{
			this.rectangle.setFillColour("#DFDFDF");
		}
		this.initiating = b;
	}
	
	public boolean isInitiating() {
		return initiating;
	}
	
	@Override
	public HashSet<IDiagramElementGraphicState> getStates() {
		
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();
		
		states.addAll(super.getStates());
		
		ChoreographyStates ct = new ChoreographyStates();
		
		states.add(ct.new ParticipantState());
		
		return states;
	}
	
	public void setLevel(ParticipantLevel level){
		
		
		if (level == ParticipantLevel.TOP){
			
			this.rectangle.setHeight(DEFAULT_HEIGHT-2);
			this.rectangle.setY(2);
			this.linearPath.setY(DEFAULT_HEIGHT);
			this.rectangle.setWidth(DEFAULT_WIDTH-3);
			this.rectangle.setX(2);
			this.rectangle.setStokeColour("none");
			this.linearPath.setVisible(true);
			
		}else if (level == ParticipantLevel.MIDDLE){
			
			this.rectangle.setHeight(DEFAULT_HEIGHT);
			this.rectangle.setY(0);
			this.rectangle.setWidth(DEFAULT_WIDTH);
			this.rectangle.setX(0);
			this.rectangle.setStokeColour("black");
			this.linearPath.setVisible(false);	
			
		}else if (level == ParticipantLevel.BOTTOM){
			
			this.rectangle.setHeight(DEFAULT_HEIGHT-2);
			this.rectangle.setY(0);
			this.linearPath.setY(0);
			this.rectangle.setWidth(DEFAULT_WIDTH-3);
			this.rectangle.setX(2);
			this.rectangle.setStokeColour("none");
			this.linearPath.setVisible(true);		
			
		}
		
		this.level = level;
		
	}
	
	
	public ParticipantLevel getLevel() {
		return level;
	}
	
	

	@Override
	public SVGElement getMainShape() {
		
		if (rectangle==null){
			rectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 150, DEFAULT_HEIGHT,0);
			rectangle.setFillColour("white");
			rectangle.setStokeColour("#000000");
		}
			
		return rectangle;
	}

	@Override
	public void refresh() {

	}

	@Override
	public String getName() {
		return "Participant";
	}

	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		
		HashSet<IDiagramElementViewConformityRule> result  = new HashSet<IDiagramElementViewConformityRule>();
		
		ParticipantRules prules = new ParticipantRules(this);
		
		result.addAll(prules.getRules());
		
		return result;
	}

	@Override
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(PoolEditorModel.class);
		}
		
		return editorModel;
	}

	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();

		return result;
	}
	
	
	public enum ParticipantLevel{
		TOP,MIDDLE,BOTTOM
	}


	@Override
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}

	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		//Message
		MessageMenuDragProxy mmdp = new MessageMenuDragProxy(getUIPanel());
		mmdp.setSmallIcon(true);
		mmdp.setLabelVisible(false);
		
		dps.add(mmdp);
		
		return dps;
	}

	@Override
	public Direction getMenuDirection() {
		return Direction.W;
	}

	@Override
	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		return defaultHandlers;
	}
	
	

}
