/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;

public class ExecutableProcessSwimlaneRules {
	
	private Swimlane swimlane;
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public ExecutableProcessSwimlaneRules(Swimlane swimlane) {
		
		this.swimlane 	= swimlane;
		this.rules 		= new HashSet<IDiagramElementViewConformityRule>();
		
		if (swimlane instanceof Pool || swimlane instanceof CollapsedPool){
			
			this.rules.add(new ParticipantMustHaveInterfaces(swimlane));
			
		}
		
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	
	////////////
	//ERRORS
	///////////////////
	
	
	//////////PARTICIPANT MUST HAVE INTERFACES 
	private class ParticipantMustHaveInterfaces extends AbstractDiagramElementViewConformityRule{

		public ParticipantMustHaveInterfaces(
				IDiagramElementView diagramElementView) {
			super(diagramElementView);
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			IParticipantBean participant = (IParticipantBean) diagramElementView.getDiagramElement().getModelElement();
			
			if (participant.getInterfaces()==null){
				return false;
			}else{
				if (participant.getInterfaces().size()==0){
					return false;
				}
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Select interfaces implemented by actual Participant";
		}

		@Override
		public String getRuleDescription() {
			return "Actual Pool (Participant) doesn't have any interfaces";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Interfaces Required";
		}

		@Override
		public void resolveNonConformity() {

		}
		
		
		
		
	}
	
}
