/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector;

import java.util.HashMap;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Group;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Text;
import com.ebmwebsourcing.geasytools.geasysvg.ext.impl.LinearPath;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorStart;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IAddIntermediateConnectorPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IAddWayPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IConnectionEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IDisconnectionEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IRefreshEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IRemoveIntermediateConnectorPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IRemoveWayPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.Connector;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.ConnectorHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.IBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DescriptiveProcessConnectorRules;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.ExecutableProcessConnectorRules;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNEdge;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;

/**
 * TODO: Make that class/package generic
 * @author nfleury
 *
 */
public abstract class ConnectorElement extends Connector implements IBPMNElement,ConnectorHandler {

	protected LinearPath invisibleLinearPath;
	protected LinearPath visibleLinearPath;
	protected Group group;
	
	private IConnectorEnd connectorEnd;
	private IConnectorStart connectorStart;
	
	private Circle docker;
	protected Text label;
	
	
	private IDiagramElement diagramElement;
	
	private ConnectorPointElement hasMouseOverConnectorPoint;
	
	public ConnectorElement(IUIPanel uipanel,String id) {
		super(uipanel,id);

//		ConnectorDefaultHandlers cdh = new ConnectorDefaultHandlers(this);
//		cdh.attachDefaultHandlers();



		this.docker = ((ProcessPanel) this.getUIPanel()).getCanvas()
				.createCircle(0, 0, 3);
		this.docker.setFillColour("yellow");
		this.docker.setVisible(false);

		
		this.label = ((ProcessPanel) this.getUIPanel()).getCanvas().createText(0, 0, "");
		


		this.refresh();
		
		
		final Timer timer = new Timer() {
			
			@Override
			public void run() {
					
				for(IConnectorPoint p:getAllConnectorPoints()){
					
					ConnectorPointElement cp = (ConnectorPointElement) p;
					
					if (cp!=hasMouseOverConnectorPoint) cp.hide();
					
				}
				
			}
		};
		
		this.addMouseOverHandler(new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				
				for(IConnectorPoint p:getAllConnectorPoints()){
					
					ConnectorPointElement cp = (ConnectorPointElement) p;
					
					cp.show();
					
				}
				
				
			}
		});



		this.addMouseMoveHandler(new MouseMoveHandler() {

			
			public void onMouseMove(MouseMoveEvent event) {
				
				docker.setVisible(true);
				docker.setX(event.getClientX()-getUIPanel().getAbsoluteLeft()+getUIPanel().getScrollLeft()+Window.getScrollLeft());
				docker.setY(event.getClientY()-getUIPanel().getAbsoluteTop()+getUIPanel().getScrollTop()+Window.getScrollTop());
				docker.toBack();
				
				timer.cancel();
				
			}
		});

		this.addMouseOutHandler(new MouseOutHandler() {

			
			public void onMouseOut(MouseOutEvent event) {

				docker.setVisible(false);

				timer.schedule(1000);
				
			}
		});

		this.addConnectorHandler(this);
		
	}
	
	
	public void setDiagramElement(IDiagramElement model) {
		this.diagramElement = model;
	};
	
	public void addBoundUpdateHandler(IBoundsUpdateHandler handler) {
		// TODO Auto-generated method stub
		
	}



	
	
	@Override
	public void removeFromParent() {
		super.removeFromParent();
		
		visibleLinearPath.remove();
		invisibleLinearPath.remove();
		docker.remove();
		label.remove();
		
	}
	
	protected void setHasMouseOverConnectorPoint(
			ConnectorPointElement hasMouseOverConnectorPoint) {
		this.hasMouseOverConnectorPoint = hasMouseOverConnectorPoint;
	}	
	
	public ConnectorElement(IUIPanel uipanel,String id, IConnectableElement source,
			IConnectableElement target) {
		super(uipanel,id, source, target);

	}
	
	@Override
	public void onRemoveIntermediateConnectorPoint(
			IRemoveIntermediateConnectorPointEvent event) {
		// TODO Auto-generated method stub
		
	}
	
	public IConnectorEnd getConnectorEndPoint() {
		if (connectorEnd == null) {
			this.connectorEnd = new ConnectorEndElement(this, 0, 0);
		}
		return connectorEnd;
	}

	
	public void toFront(){
//		linearPath.toFront();
		((ProcessPanel) this.getUIPanel()).getCanvas().appendChild(invisibleLinearPath);
	}
	
	public void hide(){
		group.setVisible(false);
		
		for(IConnectorPoint el:this.getAllConnectorPoints()){
			
			ConnectorPointElement cpe = (ConnectorPointElement) el; 
			
			cpe.hide();
		}
		
	}
	
	public void show(){
		group.setVisible(true);
		
	
	}
	
	public IConnectorStart getConnectorStartPoint() {
		if (connectorStart == null) {
			this.connectorStart = new ConnectorStartElement(this, 0, 0);
		}
		return connectorStart;
	}

	
	public void setLabel(String text){
		label.setText(text);
	}
	
	public String getLabel() {
		return label.getText();
	}
	
	@Override
	public void refresh() {
		super.refresh();
		
		invisibleLinearPath.getPoints().clear();
		// TODO: determine best path

		// - rebuild it with new points starting with start point

		IConnectorPoint previousConnectorPoint = this.connectorStart;
		com.ebmwebsourcing.geasytools.geasysvg.ext.impl.Point previousPoint = null;

		while (previousConnectorPoint != null) {

			com.ebmwebsourcing.geasytools.geasysvg.ext.impl.Point point = new com.ebmwebsourcing.geasytools.geasysvg.ext.impl.Point(
					previousConnectorPoint.getRelativeX()+getUIPanel().getScrollLeft(),
					previousConnectorPoint.getRelativeY()+getUIPanel().getScrollTop());

			if (previousPoint != null)
				previousPoint.setNextPoint(point);

			invisibleLinearPath.addPoint(point);

			previousConnectorPoint = previousConnectorPoint.getNextPoint();
			previousPoint = point;
		}

		invisibleLinearPath.connectAllPoints();
		refreshLabelPosition();
		
		invisibleLinearPath.getElement().setAttribute("stroke-width", "7");
		invisibleLinearPath.getElement().setAttribute("pointer-events", "painted");
		invisibleLinearPath.getElement().setAttribute("visibility", "hidden");
		//invisibleLinearPath.toFront();
		this.visibleLinearPath.getElement().setAttribute("d", this.invisibleLinearPath.getElement().getAttribute("d"));
		//visibleLinearPath.toBack();
		this.group.toFront();
	}

	public HashMap<Direction, Point> getIntersectionPoints() {

		HashMap<Direction, Point> ip = new HashMap<Direction, Point>();

		ip.put(Direction.NE, new Point(connectorStart.getAbsoluteLeft(),
				connectorStart.getAbsoluteTop()));
		ip.put(Direction.SE, new Point(connectorEnd.getAbsoluteLeft(),
				connectorEnd.getAbsoluteTop()));

		return ip;
	}


	public void setHeight(float width) {

	}

	
	public void setRelativeX(float x) {
		invisibleLinearPath.setX(x);
		connectorStart.setRelativeX(x);
		connectorEnd.setRelativeX(x+100);
		refresh();
	}

	
	public void setRelativeY(float y) {
		invisibleLinearPath.setY(y);
		connectorStart.setRelativeY(y);
		connectorEnd.setRelativeY(y);
		refresh();
	}

	protected void refreshLabelPosition(){
		
		label.setX((this.getRelativeX())+(this.getWidth()/2));
		label.setY((this.getRelativeY())+(this.getHeight()/2)-10);
		
	}
	
	
	public int getAbsoluteLeft() {
		return (int) this.getNWPoint().getX();
	}

	
	public int getAbsoluteTop() {
		return (int) this.getNWPoint().getY();
	}

	
	@Override
	public void onAddIntermediateConnectorPoint(
			IAddIntermediateConnectorPointEvent event) {
	
		
	}
	
	public void onAddWayPointRequest(IAddWayPointEvent event) {
//		
//		System.out.println("wayPoint position:"+event.getWayPointPosition());
//		System.out.println("waypoint previous point:"+event.getPreviousPoint().getId());
//		System.out.println("waypoint next point:"+event.getNextPoint().getId());
		ConnectorPointElement cpel = new ConnectorPointElement(this, event.getWayPointPosition().getX(), event.getWayPointPosition().getY());
		
		this.addIntermediateConnectorPoint(cpel, event.getPreviousPoint(), event.getNextPoint());		

		this.refresh();
		
	}

	
	public void onConnection(IConnectionEvent event) {
		
		String sourceId = "null";
		String targetId = "null";
		
		if (event.getConnectionSource()!=null) sourceId = event.getConnectionSource().getId();
		if (event.getConnectionTarget()!=null) targetId = event.getConnectionTarget().getId();
		
//		System.out.println("Connector:"+this.getId()+" have been connected source id:"+sourceId+" target id:"+targetId);
//		
//		if (event.getConnectionSource()!=null){
//			System.out.println("Source has:"+event.getConnectionSource().getIncommingConnectors().size()+" incomming connectors & "+event.getConnectionSource().getOutgoingConnectors().size()+" outgoing connectors");
//		}
//		
//		if (event.getConnectionTarget()!=null){
//			System.out.println("Target has:"+event.getConnectionTarget().getIncommingConnectors().size()+" incomming connectors & "+event.getConnectionTarget().getOutgoingConnectors().size()+" outgoing connectors");
//		}
		
	}

	
	public void onRemoveWayPoint(IRemoveWayPointEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public Widget getMainWidget() {

		if (group==null){
			this.group = ((ProcessPanel) this.getUIPanel()).getCanvas().createGroup();
			
			this.visibleLinearPath	= ((ProcessPanel) this.getUIPanel()).getCanvas()
			.createLinearPath(0,0);
			this.invisibleLinearPath = ((ProcessPanel) this.getUIPanel()).getCanvas()
			.createLinearPath(0,0);
			
			//this.invisibleLinearPath.setVisible(false);
			this.group.appendChild(visibleLinearPath);
			this.group.appendChild(invisibleLinearPath);

		}
		
		return group;
	}

	public IDiagramElement getDiagramElement() {
		
		if (diagramElement==null){
			this.diagramElement = GWT.create(BPMNEdge.class);
		}
		
		return diagramElement;
	}





	public void toBack() {
		invisibleLinearPath.toBack();
	}

	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();
		
		DescriptiveProcessConnectorRules descRules = new DescriptiveProcessConnectorRules(this);
		rules.addAll(descRules.getRules());
		
		if (((ProcessPanel)getUIPanel()).isExecutableProcess()){
			ExecutableProcessConnectorRules execRules = new ExecutableProcessConnectorRules(this);
			rules.addAll(execRules.getRules());
		}
		
		
		return rules;
	}
	
	
	public void onDisconnection(IDisconnectionEvent event) {
		
//		System.out.println("Connector:"+this.getId()+" have been disconnected");
		
		IConnectableElement source = event.getDisconnectedSource();
		IConnectableElement target = event.getDisconnectedTarget();
		
//		if (target !=null){
//			
//			System.out.println("Previous target element now have:"+target.getIncommingConnectors().size()+" incomming connectors & "+target.getOutgoingConnectors().size()+" outgoing connectors");
//			
//		}else if (source !=null){
//			
//			System.out.println("Previous source element now have:"+source.getOutgoingConnectors().size()+" outgoing connectors & "+source.getIncommingConnectors().size()+" incomming connectors");
//			
//		}
		
	}
	
	@Override
	public IConnectorPoint createConnectorPoint(int x, int y) {
		return new ConnectorPointElement(this, x, y);
	}
	
	@Override
	public void onRefresh(IRefreshEvent event) {
		// TODO Auto-generated method stub
		
	}

}
