/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors;


import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IMainModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.AssociationEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectorElement;
import com.google.gwt.core.client.GWT;

public class Association extends ConnectorElement {

	
	private AssociationEditorModel editorModel ;

	private IMainModelElement mainModel;
	
	public Association(IUIPanel uipanel, String id) {
		super(uipanel, id);
				
		this.visibleLinearPath.setStrokeDashArray("- ");
		

		
	}

	@Override
	public String getName() {
		return "Association";
	}



	@Override
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			
			editorModel = GWT.create(AssociationEditorModel.class);
			
		}
		
		return editorModel;
	}



	@Override
	public HashSet<IDiagramElementGraphicState> getStates() {
		
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();
		
		return states;
	}




	
	public IMainModelElement getMainModel(){
		return this.mainModel;
	}
	
	public void setMainModel(IMainModelElement mainModel){
		this.mainModel = mainModel;
	}

}
