/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data.DataEditorModel;

public class ExecutableProcessDataRules {

	private HashSet<IDiagramElementViewConformityRule> rules;

	public ExecutableProcessDataRules(Data data) {
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		rules.add(new DataItemDefinitionMustBeSet(data));
	}

	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	
	
	
	private class DataItemDefinitionMustBeSet extends AbstractDiagramElementViewConformityRule {
		
		public DataItemDefinitionMustBeSet(Data data) {
			super(data);
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			DataEditorModel em = (DataEditorModel) diagramElementView.getEditorModel();
			return em.getItemSubject()!=null;
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Please set the Item Subject property.";
		}

		@Override
		public String getRuleDescription() {	
			return "A data object must have its data structure set.";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Data Objects/Imputs/Outputs data structure is required.";
		}

		@Override
		public void resolveNonConformity() {
			
		}
	}
	
}
