/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementViewInstantiationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.TerminateEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.TimerEventDefinitionBean;

public abstract class CommonEventInstantiationHandler implements IDiagramElementViewInstantiationHandler<Event>{

	@Override
	public Event instantiate(IDiagramElement diagramElement,
			IDiagramView diagramView) {
		return createElement(diagramElement.getModelElement(), diagramView);
	}

	@Override
	public Event instantiate(IHasDragProxy draggableProxyData,
			IDiagramView diagramView) {
		
		return createElement(null, diagramView);
	}


	@Override
	public Event createElement(IModelElement syntaxModel,
			IDiagramView diagramView) {
		
		String id = IdGenerator.createUniqueId();
		
		if (syntaxModel!=null){
			
			id = syntaxModel.getId();
			
		        //Start events
		        if (syntaxModel instanceof StartEventBean){
		                
		                StartEventBean startEventBean = (StartEventBean) syntaxModel;
		                
		                //Start none Event
		                if (startEventBean.getTriggers().size()==0){
		
		                        return new StartTopLevelNoneEvent((ProcessPanel) diagramView, id);
		                        
		                }else if (startEventBean.getTriggers().size()==1){
		                        
		                        //Start Message Event
		                        if (startEventBean.getTriggers().get(0) instanceof MessageEventDefinitionBean){
		                                
		                                return new StartTopLevelMessageEvent((ProcessPanel) diagramView, id);
		                        
		                        //Start Timer Event     
		                        }else if(startEventBean.getTriggers().get(0) instanceof TimerEventDefinitionBean) {
		                                
		                                return new StartTimerEvent((ProcessPanel) diagramView, id);
		                                
		                        }
		                        
		                        
		                }
		                
		        //INTERMEDIATE CATCH 
		        }else if (syntaxModel instanceof IntermediateCatchEventBean){
		                
		                IntermediateCatchEventBean intermediateCatch = (IntermediateCatchEventBean) syntaxModel;
		                
		                if (intermediateCatch.getTriggers().size()==1){
		                        
		                        //Message
		                        if (intermediateCatch.getTriggers().get(0) instanceof MessageEventDefinitionBean){
		                                
		                                return new IntermediateCatchingMessageEvent((ProcessPanel) diagramView, id);
		                                
		                        //Timer 
		                        }else if (intermediateCatch.getTriggers().get(0) instanceof TimerEventDefinitionBean){
		                                
		                                return new IntermediateCatchingTimerEvent((ProcessPanel) diagramView, id);
		                                
		                        }
		                        
		                }
		                
		                
		        //INTERMEDIATE THROW
		        }else if (syntaxModel instanceof IntermediateThrowEventBean){      
		                
		                IntermediateThrowEventBean intermediateThrow = (IntermediateThrowEventBean) syntaxModel;
		                
		                if (intermediateThrow.getResults().size()==1){
		                        
		                        //Message
		                        if (intermediateThrow.getResults().get(0) instanceof MessageEventDefinitionBean){
		                                
		                                return new IntermediateThrowingMessageEvent((ProcessPanel) diagramView, id);
		                                
		                        }
		                        
		                }
		                
		        //END EVENT     
		        }else if (syntaxModel instanceof EndEventBean){
		                
		                EndEventBean endEventBean = (EndEventBean) syntaxModel;
		                
		                //End none Event
		                if (endEventBean.getResults().size()==0){
		                        
		                        return new EndNoneEvent((ProcessPanel) diagramView, id);
		
		                //End   
		                }else if (endEventBean.getResults().size()==1){
		                        
		                        //Message
		                        if (endEventBean.getResults().get(0) instanceof MessageEventDefinitionBean){
		                                                        
		                                return new EndMessageEvent((ProcessPanel) diagramView, id);
		                        
		                        //Terminate
		                        }else if (endEventBean.getResults().get(0) instanceof TerminateEventDefinitionBean){
		                                
		                                return new TerminateEvent((ProcessPanel) diagramView, id);
		                        }
		                        
		                        
		                }
		                
		                
		        }
        
		}else{
			
			return getDefaultEvent(diagramView);
			
		}
		
		
        return null;

	}
	
	
	public abstract Event getDefaultEvent(IDiagramView diagramView);
	
}
