/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.gateway.ExclusiveGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.DefaultSequenceFlowState;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.google.gwt.core.client.GWT;

public class ExclusiveGateway extends Gateway {
	
	private Path mainPath;
	
	
	private ConnectableElementDefaultHandlers defaultHandlers;
	
	private ExclusiveGatewayEditorModel editorModel;
	
	private DefaultSequenceFlowState defaultSequenceFlowState;
	
	public ExclusiveGateway(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id);

		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.defaultSequenceFlowState = new DefaultSequenceFlowState();
	}
	
	public String getName() {
		return "Exclusive Gateway";
	}
	
	@Override
	protected void init() {
		super.init();
		
		mainPath = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.GATEWAY_EXCLUSIVE, 0, 0);
		mainPath.setStokeColour("#8B5E3C");
		mainPath.setFillColour("#8B5E3C");
		mainPath.translate(-5, -3);
		
		getGroup().appendChild(mainPath);
		
	}
	

	@Override
	public HashSet<IDiagramElementGraphicState> getStates() {
		
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();
		
		states.addAll(super.getStates());
		
		states.add(defaultSequenceFlowState);
		
		return states;
	}
	
	
	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		// TODO Auto-generated method stub
		return null;
	}



	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(ExclusiveGatewayEditorModel.class);
		}
		
		return editorModel;
	}



	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub

	}

	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub

	}

	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub

	}


	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();
		
		rules.addAll(super.getConformityRules());
		
		if (getDefinitionPanel().isExecutableProcess()){
			
			rules.addAll(new ExecutableProcessGatewayRules(this).getRules());
			
		}
		
		return rules;
	}



//
//	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
//		// TODO Auto-generated method stub
//		return null;
//	}

}
