/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.TaskMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.artifact.TextAnnotationMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.choreography.ChoreographyTaskMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.SequenceFlowMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndNoneMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateCatchingMessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateThrowingMessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ConnectableFlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ContextualMenuHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectionMode;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;


public abstract class Gateway extends ConnectableFlowElement implements IHasDragProxyContextualMenu{

	private Rectangle invisibleRectangle;
	
	public Gateway(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id,ConnectionMode.MIDDLES);
	
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
		
		this.addDropHandler(this);
	}

	
	@Override
	protected void init() {
		super.init();
		
		this.label = this.getDefinitionPanel().getCanvas().createText(this.getWidth()/2, this.getHeight()+15, "");
		getGroup().appendChild(label);
	}
	
	@Override
	public SVGElement getMainShape() {
		
		if (invisibleRectangle==null){
			
			invisibleRectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 22, 22);
			invisibleRectangle.setFillColour("white");
			invisibleRectangle.setStokeColour("white");
			invisibleRectangle.rotate(50, false);
		}
		
		return invisibleRectangle;
	}
	
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}
	
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		//CHOREOGRAPHY
		ChoreographyTaskMenuDragProxy ctdp = new ChoreographyTaskMenuDragProxy(this.getUIPanel());
		ctdp.setLabelVisible(false);
		ctdp.setSmallIcon(true);
		
		//ACTIVITY
		TaskMenuDragProxy tdp = new TaskMenuDragProxy(this.getUIPanel());
		tdp.setLabelVisible(false);
		tdp.setSmallIcon(true);
		
		ExclusiveGatewayMenuDragProxy gdp = new ExclusiveGatewayMenuDragProxy(getUIPanel());
		gdp.setLabelVisible(false);
		gdp.setSmallIcon(true);
		
		//INTERMEDIATE THROWING
		IntermediateThrowingMessageMenuDragProxy it1 = new IntermediateThrowingMessageMenuDragProxy(getUIPanel());
		it1.setLabelVisible(false);
		it1.setSmallIcon(true);
		
		//INTERMEDIATE CATCHING
		IntermediateCatchingMessageMenuDragProxy ic1 = new IntermediateCatchingMessageMenuDragProxy(getUIPanel());
		ic1.setLabelVisible(false);
		ic1.setSmallIcon(true);		
		
		//END EVENT
		EndNoneMenuDragProxy endNoneDragProxy = new EndNoneMenuDragProxy(getUIPanel());
		endNoneDragProxy.setLabelVisible(false);
		endNoneDragProxy.setSmallIcon(true);
		
		
		//CONNECTORS
		SequenceFlowMenuDragProxy sdp = new SequenceFlowMenuDragProxy(getUIPanel());
		sdp.setLabelVisible(false);
		sdp.setSmallIcon(true);
		
		//Artifacts
		TextAnnotationMenuDragProxy tamdp = new TextAnnotationMenuDragProxy(getUIPanel());
		tamdp.setLabelVisible(false);
		tamdp.setSmallIcon(true);
		
		if ( (this.getUIPanel() instanceof ChoreographyPanel) == true) dps.add(ctdp);
		if ( (this.getUIPanel() instanceof ChoreographyPanel) == false) dps.add(tdp);
		
		
		dps.add(gdp);
		dps.add(it1);
		dps.add(ic1);
		dps.add(endNoneDragProxy);
		dps.add(sdp);
		dps.add(tamdp);
		
		
		
		return dps;
	}
	
	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		 HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
			
		 result.add(SequenceFlow.class);
		 
		 return result;
	}
	

	
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();
		
		DescriptiveProcessGatewayRules descRule = new DescriptiveProcessGatewayRules(this);
		
		rules.addAll(descRule.getRules());
		
		return rules;
	}
	
	
	public void onDropAccepted(IDropAcceptedEvent event) {
		//if a sequence flow is dropped from a HasMenuDragProxy connect  
		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==SequenceFlow.class){
					
					SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
					getUIPanel().addUIElement(sf);
					
					sf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
	}
	
}
