/**
 * petalsbpm-domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard;

import java.io.Serializable;

public interface Constants extends Serializable {
    
    public static final String EXPORTER = "PetalsBPM";
    public static final String BPMN_NS = "http://www.omg.org/spec/BPMN/20100524/MODEL";

    public enum ProcessTypes {
        NONE("None"), PUBLIC("Public"), PRIVATE("Private");

        private final String value;

        private ProcessTypes(String value) {
            this.value = value;
        }

        private String getValue() {
            return value;
        }

        public boolean equals(ProcessTypes other) {
            return this.value.equals(other.getValue());
        }
        
        @Override
        public String toString() {
            return value;
        }
    }

    public enum ItemKind {
        INFORMATION("Information"), PHYSICAL("Physical");

        private final String value;

        ItemKind(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ItemKind fromValue(String v) {
            for (ItemKind c : ItemKind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }
        
        @Override
        public String toString() {
            return value;
        }
    }
    
    public enum ImportType{
    	XMLSchema("http://www.w3.org/2001/XMLSchema","XML Schema"),
    	WSDL2_0("http://www.w3.org/TR/wsdl20/","WSDL 2.0"),
    	WSDL1_1("http://schemas.xmlsoap.org/wsdl","WSDL 1.1"),
    	BPMN2_0("http://www.omg.org/spec/BPMN/20100524/MODEL","BPMN 2.0");
    	
    	private String value;
    	private String label;
    	
    	ImportType(String value,String label){
    		this.value = value;
    		this.label = label;
    	}
    	
    	public String getValue() {
			return value;
		}
    	
    	public String getLabel() {
			return label;
		}
    	
    	public static ImportType fromValue(String value){
    		for(ImportType i:ImportType.values()){
    			if (i.getValue().equals(value)){
    				return i;
    			}
    		}
    		throw new IllegalArgumentException(value);
    	}
    	
    	@Override
    	public String toString() {
    		return label;
    	}
    	
    }
    
    public enum EventGatewayType {
        Exclusive, Parallel;
    }

    public enum ChoreographyLoopType {
        None, Standard, MultiInstanceSequential, MultiInstanceParallel;
    }

    public enum AssociationDirection {
        None, One, Both;
    }
    
    public enum TaskType{
        RECEIVE_TASK, SEND_TASK, SERVICE_TASK, NONE, MANUAL,USER,BUSINESS,SCRIPT;
    }

}
