/**
 * petalsbpm-domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process;

import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.WithFlowElementsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ILaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.ICallableElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.WithArtifactsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IMainElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IInputOutputBinding;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;

public interface IProcessBean extends IBaseElementBean, WithFlowElementsBean, WithArtifactsBean,
        IMainElementBean ,ICallableElementBean{

    public ProcessTypes getType();

    public boolean isClosed();
    
    public boolean isExecutable();
    
    public ITaskBean getTaskById(String arg0);

    public IGatewayBean getGatewayById(String arg0);

    public IStartEventBean getStartEventById(String arg0);

    public IEndEventBean getEndEventById(String arg0);

    public IIntermediateCatchEventBean getIntermediateCatchEventById(String arg0);

    public IIntermediateThrowEventBean getIntermediateThrowEventById(String arg0);

    public IDataObjectBean getDataObjectById(String arg0);

    public List<? extends IFlowElementBean> getFlowNodes();

    public boolean removeFlowElement(IFlowElementBean arg0);

    public void setType(ProcessTypes arg0);

    public void setIsClosed(boolean arg0);
    
    public void setExecutable(boolean arg0);

    public ICollaborationBean getDefinitionalCollaboration();
    
    public void setDefinitionalCollaboration(ICollaborationBean c);
    
    public void setIOBindings(List<IInputOutputBinding> ioBinding);
    
    //not part of spec
    public void addLane(ILaneBean lane);
    
    public void removeLane(ILaneBean lane);
    
    public List<ILaneBean> getLanes();
    
    public void addFlowElement(IFlowElementBean flowElement);
    
    public void clearFlowElements();

	public void clearIOSpec();
    
}
