/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasyschema.domain.api.IElement;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ImportType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ItemKind;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.xsd.IXSDImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.ImportBean;

public class XSDImportBean extends ImportBean implements IXSDImportBean {

    private ISchema schema;

    protected XSDImportBean() {
        super();
    }

    public XSDImportBean(INamespaceDeclaration namespaceDeclaration, ISchema schema) {
        super(namespaceDeclaration);
        this.schema = schema;
    }
    
    @Override
    public String getImportType() {
        return ImportType.XMLSchema.getValue();
    }

    @Override
    public ISchema getSchema() {
        return schema;
    }

	@Override
	public List<IItemDefinitionBean> getItemDefinitions() {
		List<IItemDefinitionBean> result = new ArrayList<IItemDefinitionBean>();
        for(IElement elt : schema.getElements()) {
            ItemDefinitionBean idb = new ItemDefinitionBean(elt.getName()+"ItemDefinition");
            idb.setItemKind(ItemKind.INFORMATION);
            idb.setStructureRef(getNSDeclaration().getPrefix()+":"+elt.getName());
            result.add(idb);
        }
        return result;
	}

}
