/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IIOSpecificationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

public class IOSpecificationBean extends BaseElementBean implements IIOSpecificationBean{

	private List<IDataInputBean> dataInputs;
	private List<IDataOutputBean> dataOutputs;
	
	public IOSpecificationBean(){
		this(IdGenerator.createUniqueId());
	}
	
	public IOSpecificationBean(String id){
		super(id);
		dataInputs = new ArrayList<IDataInputBean>();
        dataOutputs = new ArrayList<IDataOutputBean>();
	}

	@Override
	public void addDataInput(IDataInputBean d){
		if (dataInputs.contains(d)==false) dataInputs.add(d);
	}
	@Override
	public void removeDataInput(IDataInputBean d){
		dataInputs.remove(d);
	}
	@Override
	public void addDataOutput(IDataOutputBean d){
		if (dataOutputs.contains(d)==false) dataOutputs.add(d);
	}
	@Override
	public void removeDataOutput(IDataOutputBean d){
		dataOutputs.remove(d);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IDataInputBean> getDataInputs() {
		return dataInputs;
	}
	public void setDataInputs(List<IDataInputBean> dataInputs) {
		this.dataInputs = dataInputs;
	}
	public List<IDataOutputBean> getDataOutputs() {
		return dataOutputs;
	}
	public void setDataOutputs(List<IDataOutputBean> dataOutputs) {
		this.dataOutputs = dataOutputs;
	}
	
}
