/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IInputOutputBinding;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

public class InputOutputBindingBean extends BaseElementBean implements IInputOutputBinding{

    private IOperationBean operation;
    private IDataInputBean inputData;
    private IDataOutputBean outputData;

    protected InputOutputBindingBean() {
        super();
    }
    
    public InputOutputBindingBean(String id) {
        super(id);
    }
    
    @Override
    public IDataInputBean getInputData() {
        return inputData;
    }

    @Override
    public IOperationBean getOperation() {
        return operation;
    }

    @Override
    public IDataOutputBean getOutputData() {
        return outputData;
    }

    public void setOperation(IOperationBean operation) {
        this.operation = operation;
    }

    public void setInputData(IDataInputBean inputData) {
        this.inputData = inputData;
    }

    public void setOutputData(IDataOutputBean outputData) {
        this.outputData = outputData;
    }
    
    
}
