/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IItemAwareElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.ICatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;



public abstract class CatchEventBean extends EventBean implements ICatchEventBean {
	
	private List<IEventDefinitionBean> triggers;
	private List<IDataAssociationBean> dataOutputAssociations;
	private List<IDataOutputBean> dataOutputs;
	private Set<IItemAwareElementBean> outgoingItemAwareElements;

	public CatchEventBean(String id){
		super(id);
		triggers = new ArrayList<IEventDefinitionBean>();
		dataOutputAssociations = new ArrayList<IDataAssociationBean>();
		dataOutputs = new ArrayList<IDataOutputBean>();
		outgoingItemAwareElements = new HashSet<IItemAwareElementBean>();
	}
	
	protected CatchEventBean(){
		this(IdGenerator.createUniqueId());
	}
	
	public void addTrigger(IEventDefinitionBean e){
	    if(!triggers.contains(e)) {
	        triggers.add(e);
	    }
	}
	
	public void removeTrigger(IEventDefinitionBean e){
		triggers.remove(e);
	}
	public void addDataOutput(IDataOutputBean d){
		if(!dataOutputs.contains(d)) {
			dataOutputs.add(d);
		}
	}
	public void removeDataOutput(IDataOutputBean d){
		dataOutputs.remove(d);
	}
	public void addDataOutputAssociation(IDataAssociationBean d){
		if(!dataOutputAssociations.contains(d)) {
			dataOutputAssociations.add(d);
		}
	}
	public void removeDataOutputAssociation(IDataAssociationBean d){
		dataOutputAssociations.remove(d);
	}
	@Override
	public void addDataOutput(IDataOutputBean source,IItemAwareElementBean target) {
		this.outgoingItemAwareElements.add(target);

		this.addDataOutput(source);
		
		if (this.getProcess()!=null){
			//if its a dataObject add it to current process
			if (target instanceof IDataObjectBean){
				IDataObjectBean dataObject = (IDataObjectBean) target;
				this.getProcess().addDataObject(dataObject);
			//if its a dataInput/dataOuput add it to current processes ioSpecification				
			}else if (target instanceof IDataInputBean){
				IDataInputBean dinput = (IDataInputBean) target;
				this.getProcess().getIoSpecification().addDataInput(dinput);
			}else if(target instanceof IDataOutputBean){
				IDataOutputBean doutput = (IDataOutputBean) target;
				this.getProcess().getIoSpecification().addDataOutput(doutput);
			}
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IEventDefinitionBean> getTriggers() {
		return triggers;
	}
	public void setTriggers(List<IEventDefinitionBean> triggers) {
		this.triggers = triggers;
	}
	public List<IDataOutputBean> getDataOutputs() {
		return dataOutputs;
	}
	public void setDataOutputs(List<IDataOutputBean> dataOutputs) {
		this.dataOutputs = dataOutputs;
	}
	public List<IDataAssociationBean> getDataOutputAssociations() {
		return dataOutputAssociations;
	}
	public void setDataOutputAssociations(List<IDataAssociationBean> dataOutputAssociations) {
		this.dataOutputAssociations = dataOutputAssociations;
	}
	public Set<IItemAwareElementBean> getOutgoingItemAwareElements() {
		return outgoingItemAwareElements;
	}
	public void setOutgoingItemAwareElements(
			Set<IItemAwareElementBean> outgoingItemAwareElements) {
		this.outgoingItemAwareElements = outgoingItemAwareElements;
	}
	
}
