/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive;

import java.util.Arrays;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.panel.Panel;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IConfigurationPanelHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IUploadMetaDataRequestResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.UploadMetaDataRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNImportProjectInstanceMetaData;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNMetaDataFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.ExternalImportType;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.SchemaProjectInstanceMetaData;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.WSDLProjectInstanceMetaData;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.PetalsMasterInquiryWindow;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Configuration;
import com.ebmwebsourcing.petalsbpm.definitionseditor.DefinitionsController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.DefinitionsEditor;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.DefinitionsAvailableImport;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.ImportPanelHandler;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.SelectAddExternalImportEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.events.SelectAvailableImportEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectConfigurationData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.gwtext.client.widgets.event.WindowListenerAdapter;

public class EditBPMNDefinitionsConfigurationPanel extends Panel implements IEditConfigurationPanel{
	
	private DefinitionsController defsController;
	private DefinitionsEditor definitionsEditor;
	private IProjectPlugin<?> plugin;
	
	
	public EditBPMNDefinitionsConfigurationPanel(final IProjectPlugin<?> p,IProjectInstance projectInstance,boolean isExecutable) {
		this.setTitle("BPMN Definitions");
		this.setHeader(false);
		
		this.plugin = p;
		
		////////////////////:::
		Configuration conf = new Configuration();
		
		if (isExecutable==false){

		conf.setShowErrorPanel(false);
		conf.setShowEventDefinitionPanel(false);
		conf.setShowImportNSPanel(true);
		conf.setShowImportPanel(true);
		conf.setShowInterfacePanel(false);
		conf.setShowitemDefinitionPanel(false);
		conf.setShowMessagePanel(false);
		conf.setShowSignalPanel(false);
		
		}
		
		this.definitionsEditor = new DefinitionsEditor(conf);
		
		BPMNProjectInstance bpmnProjectInstance = (BPMNProjectInstance) projectInstance;
		this.defsController = new DefinitionsController(definitionsEditor,bpmnProjectInstance.getDefinitions());

		List<ExternalImportType> externalImportTypes = Arrays.asList(ExternalImportType.values());
		definitionsEditor.getImportPanel().setExternalImportTypes(externalImportTypes);
		
		definitionsEditor.getImportPanel().addImportPanelHandler(new ImportPanelHandler() {
			
			@Override
			public void onSelectAvailableImport(SelectAvailableImportEvent event) {
				
			}
			
			@Override
			public void onSelectAddExternalImport(SelectAddExternalImportEvent event) {

				if (event.getSelectedImportType()==ExternalImportType.UPLOAD_WSDL1_1){
					plugin.getEventBus().fireEvent(new RequestEvent(new GetActualProjectInstanceRequest(), new IGetActualProjectInstanceResponseHandler() {
						@Override
						public void receiveResponse(final IProjectInstance projectInstance) {
							plugin.getEventBus().fireEvent(new RequestEvent(new UploadMetaDataRequest(projectInstance, BPMNMetaDataFormat.WSDL1_1, "Upload a WSDL", "Select a WSDL 1.1 File from your desktop"),new IUploadMetaDataRequestResponseHandler() {
								@Override
								public void receiveResponse(IProjectInstanceMetaData result) {
								    WSDLProjectInstanceMetaData data = (WSDLProjectInstanceMetaData) result;
								    DefinitionsAvailableImport.getInstance().addImport(data.getWsdlImport());
									projectInstance.addMetadata(result);
								}
							}));
						}
					}));
				}
				
				else if (event.getSelectedImportType()==ExternalImportType.UPLOAD_XSD){
                    plugin.getEventBus().fireEvent(new RequestEvent(new GetActualProjectInstanceRequest(), new IGetActualProjectInstanceResponseHandler() {
                        @Override
                        public void receiveResponse(final IProjectInstance projectInstance) {
                            plugin.getEventBus().fireEvent(new RequestEvent(new UploadMetaDataRequest(projectInstance, BPMNMetaDataFormat.XSD, "Upload a XML Schema", "Select a XSD 1.0 File from your desktop"),new IUploadMetaDataRequestResponseHandler() {
                                @Override
                                public void receiveResponse(IProjectInstanceMetaData result) {
                                    SchemaProjectInstanceMetaData data = (SchemaProjectInstanceMetaData) result;
                                    DefinitionsAvailableImport.getInstance().addImport(data.getXsdImport());
                                    projectInstance.addMetadata(result);
                                }
                            }));
                        }
                    }));
                }
				
				else if (event.getSelectedImportType()==ExternalImportType.UPLOAD_BPMN2_0){
                    plugin.getEventBus().fireEvent(new RequestEvent(new GetActualProjectInstanceRequest(), new IGetActualProjectInstanceResponseHandler() {
                        @Override
                        public void receiveResponse(final IProjectInstance projectInstance) {
                            plugin.getEventBus().fireEvent(new RequestEvent(new UploadMetaDataRequest(projectInstance, BPMNMetaDataFormat.BPMN2_0, "Upload BPMN 2.0 Definitions", "Select a BPMN 2.0 File from your desktop"),new IUploadMetaDataRequestResponseHandler() {
                                @Override
                                public void receiveResponse(IProjectInstanceMetaData result) {
                                    BPMNImportProjectInstanceMetaData data = (BPMNImportProjectInstanceMetaData) result;
                                    DefinitionsAvailableImport.getInstance().addImport(data.getBpmnImport());
                                    projectInstance.addMetadata(result);
                                }
                            }));
                        }
                    }));
                }
				
				else if(event.getSelectedImportType()==ExternalImportType.PETALS_MASTER) {
				    plugin.getEventBus().fireEvent(new RequestEvent(new GetActualProjectInstanceRequest(), new IGetActualProjectInstanceResponseHandler() {
                        @Override
                        public void receiveResponse(final IProjectInstance projectInstance) {
                            final PetalsMasterInquiryWindow w = new PetalsMasterInquiryWindow(projectInstance);
                            w.addListener(new WindowListenerAdapter() {
                                @Override
                                public boolean doBeforeClose(com.gwtext.client.widgets.Panel panel) {
                                    for(IProjectInstanceMetaData m : w.getProjectMetadata()) {
                                        WSDLProjectInstanceMetaData data = (WSDLProjectInstanceMetaData) m;
                                        DefinitionsAvailableImport.getInstance().addImport(data.getWsdlImport());
                                        projectInstance.addMetadata(m);
                                    }
                                    return true;
                                }
                            });
                            w.show();
                        }
				    }));
				}
				
			}
		});
		

		this.add(definitionsEditor);
		
		
		
	}
	
	@Override
	public String getConfigurationName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void addHandler(IConfigurationPanelHandler handler) {
		// TODO Auto-generated method stub
	}

	@Override
	public void onLoad(IProjectInstance projectInstance) {
		BPMNProjectInstance descriptiveProjectInstace = (BPMNProjectInstance) projectInstance;		
		this.defsController.load(descriptiveProjectInstace.getDefinitions());
	}

	@Override
	public IProjectConfigurationData onValidate() {
		// TODO Auto-generated method stub
		return null;
	}


}
