/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.choreography;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNExportFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectType;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;


public class ChoreographyProjectType extends DescriptiveBPMNProjectType {

	public ChoreographyProjectType() {
		super("BPMNChoreography", "BPMN 2.0 Choreography", "A Choreography");
		
		setLoaderQname("com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.choreography.ChoreographyProjectInstanceLoader");
		
        List<IProjectInstanceFormat> exportFormats = new ArrayList<IProjectInstanceFormat>();
        exportFormats.add(BPMNExportFormat.BPMN);
        setExportFormats(exportFormats);

        List<IProjectInstanceFormat> importFormats = new ArrayList<IProjectInstanceFormat>();
        importFormats.add(BPMNExportFormat.BPMN);
        setImportFormats(importFormats);

        setFormat(BPMNExportFormat.BPMN);
		
	}
	
	
}
