/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.message;

import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.MessageEventDefinition;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddEventDefinition;
import com.ebmwebsourcing.petalsbpm.definitionseditor.message.MessageRefComboBox;
import com.ebmwebsourcing.petalsbpm.definitionseditor.operation.OperationRefComboBox;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import com.gwtext.client.widgets.grid.GridEditor;

public class MessageEventDefinitionController extends AbstractController implements EditableGridHandler{
	
	private MessageEventDefinitionPanel panel;
	private List<IOperationBean> operationRefs;
	private List<IMessageBean> msgRefs;
	
	private Record actualRecord;
	private OperationRefComboBox oc;
	
	public MessageEventDefinitionController(MessageEventDefinitionPanel panel,List<IOperationBean> operationRefs,List<IMessageBean> msgRefs) {
		
		panel.addHandler(this);
		this.panel = panel;
		
		this.msgRefs = msgRefs;
		this.operationRefs = operationRefs;
		
		
		init();
	}
	
	private void init(){
		
		MessageRefComboBox msgC = new MessageRefComboBox(msgRefs);
		oc = new OperationRefComboBox(operationRefs); 
		
		msgC.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				actualRecord.set(MessageEventDefinition.messageRef.toString(), record.getAsObject("value"));
			}
			
		});
		
		oc.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				actualRecord.set(MessageEventDefinition.operation.toString(),record.getAsObject("value"));
			}
			
		});
		
		this.panel.getMsgRefColumn().setEditor(new GridEditor(msgC));
		
		this.panel.getOperationRefColumn().setEditor(new GridEditor(oc));
	}
	
	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}
	
	private void validate(IMessageEventDefinitionBean b){
		
		if (b.getMessage()!=null && b.getId()!=null && b.getOperation()!=null){
			fireEvent(new AddEventDefinition(b));
		}
		
	}
	
	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		validate(panel.getSelectedValues().get(0));
	}
	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		this.actualRecord = panel.getGridPanel().getStore().getAt(event.getRowIndex());
		
	}

    public void setOperationRefs(List<IOperationBean> operationRefs) {
        this.operationRefs = operationRefs;
        oc.setData(operationRefs);
    }
	
}
