/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ItemKind;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.ItemDefinition;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;



public class ItemDefinitionPanel extends AbstractEditableGrid<IItemDefinitionBean> {
	
	private ColumnConfig structurerefColumn;
	
	public ItemDefinitionPanel() {
		super();
		
	}


	@Override
	protected String getAddText() {
		return "Add Item Definition";
	}



	@Override
	protected String getRemoveText() {
		return "Remove Item Definition";
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		
		gridPanel.setAutoExpandColumn(2);
		gridPanel.getView().setForceFit(true);
		
	}

	@Override
	protected List getColumnsConfig() {

		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig itemKindColumn			= new ColumnConfig(ItemDefinition.itemKind.getLabel(), ItemDefinition.itemKind.toString());
		itemKindColumn.setEditor(new GridEditor(new ItemKindComboBox()));
		
		this.structurerefColumn				= new ColumnConfig(ItemDefinition.structureRef.getLabel(), ItemDefinition.structureRef.toString());

		
		ColumnConfig isCollectionColumn		= new ColumnConfig(ItemDefinition.isCollection.getLabel(),ItemDefinition.isCollection.toString());
		
		cc.add(itemKindColumn);
		cc.add(structurerefColumn);
		cc.add(isCollectionColumn);
		
		return cc;
	}

	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(ItemDefinition.itemKind.toString()),
				new StringFieldDef(ItemDefinition.structureRef.toString()),
				new StringFieldDef(ItemDefinition.isCollection.toString())
			};
	}

	public ColumnConfig getStructurerefColumn() {
		return structurerefColumn;
	}
	
	@Override
	protected void bind(Record record, IItemDefinitionBean value) {
		
		value.setItemKind(ItemKind.fromValue(record.getAsString(ItemDefinition.itemKind.toString())));
		value.setStructureRef(record.getAsString(ItemDefinition.structureRef.toString()));
		value.setCollection(record.getAsBoolean(ItemDefinition.isCollection.toString()));
		
	}


	@Override
	protected IItemDefinitionBean getNewDefaultRecord() {
		return new ItemDefinitionBean(DOM.createUniqueId());
	}


	@Override
	protected Object[] convertDataToObject(IItemDefinitionBean data) {
		
		Object[] object = new Object[3];
		
		object[0] = data.getItemKind();
		object[1] = data.getStructureRef();
		object[2] = data.getCollection();
		
		
		return object;
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}


	@Override
	protected boolean isValid(IItemDefinitionBean data) {
		
		if (data.getItemKind()!=null && data.getStructureRef()!=null ){
			return true;
		}
		
		return false;
	}

}
