/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.client.api.service;

import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;

public interface IProjectService {


	List<IProjectFile> getProjectFilesByProjectType(IProjectType projectType) throws ServiceException;
	
	List<IProjectInstance> loadProjectInstances(List<IProjectFile> projectFiles) throws ServiceException;

	IProjectInstance loadProjectInstanceByUrl(String url,IProjectType type,IProjectInstanceFormat format) throws ServiceException;
	
	String exportProjectInstance(IProjectInstance projectInstance,IProjectInstanceFormat format) throws ServiceException;
	
	List<IProjectInstance> importProjectInstance(String uploadedRef,IProjectType projectType,IProjectInstanceFormat format) throws ServiceException;

	IProjectFile saveProjectInstance(IProjectInstance projectInstance) throws ServiceException;

	IProjectInstance getProjectInstanceById(String id) throws ServiceException;
	
	IProjectInstanceMetaData addMetaData(String uploadRef,IProjectInstance projectInstance,IProjectInstanceFormat metaDataFormat)throws ServiceException;
}
