/**
 * webeditor-service - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.server.impl.service.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectFile;

public class ProjectServiceHelper {

	
	public static File convert(IProjectFile projectFile){
		
		File f = new File(projectFile.getAbsolutePath());
		
		if (f.isDirectory()) f = new File(projectFile.getAbsolutePath()+File.separator+projectFile.getName());
		
		return f;
	}
	
	public static List<IProjectInstance> retrieveProjectInstances(List<IProjectFile> projectFiles){
		
		List<IProjectInstance> result = new ArrayList<IProjectInstance>();
		
		for(IProjectFile f:projectFiles){
			result.add(f.getProjectInstance());
		}
		
		
		return result;
	}
	
	
	public static List<File> convert(List<IProjectFile> projectFiles){
		
		List<File> files = new ArrayList<File>();
		
		for(int i=0;i<projectFiles.size();i++){
			
			File f = convert(projectFiles.get(i));
			
			files.add(i, f);
			
		}
		
		return files;
	}
	
	public static File getFile(URL u) throws IOException{
		
		File tmpFile = new File(System.getProperty("java.io.tmpdir")+File.separator+UUID.randomUUID().toString());

		URLConnection uc = u.openConnection();
		uc.connect();
		InputStream in = uc.getInputStream();
		
		FileOutputStream out = new FileOutputStream(tmpFile);

		final int BUF_SIZE = 1 << 8;
		byte[] buffer = new byte[BUF_SIZE];
		int bytesRead = -1;
		while((bytesRead = in.read(buffer)) > -1) {
		    out.write(buffer, 0, bytesRead);
		}
		in.close();
		out.close();
		
		
		return tmpFile;


	}
	
	public static IProjectFile convert(File file){
		
		ProjectFile pf = new ProjectFile();
		
		pf.setAbsolutePath(file.getAbsolutePath());
		pf.setName(file.getName());
		
		return pf;
	}
	
}
