/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.ISubChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;

public class ChoreographyBean extends CollaborationBean implements IChoreographyBean{

    private List<ISequenceFlowBean> sequenceFlows;
    private List<IStartEventBean> startEvents;
    private List<IIntermediateCatchEventBean> intermediateCatchEvents;
    private List<IIntermediateThrowEventBean> intermediateThrowEvents;
    private List<IEndEventBean> endEvents;
    private List<IGatewayBean> gateways;
    private List<IChoreographyTaskBean> choreographyTasks;
    private List<ISubChoreographyBean> subChoreographies;
    
    
    public ChoreographyBean(){
        this(IdGenerator.createUniqueId());
    }
    
    public ChoreographyBean(String id){
        super(id);
        sequenceFlows = new ArrayList<ISequenceFlowBean>();
        startEvents = new ArrayList<IStartEventBean>();
        endEvents = new ArrayList<IEndEventBean>();
        gateways = new ArrayList<IGatewayBean>();
        intermediateCatchEvents = new ArrayList<IIntermediateCatchEventBean>();
        intermediateThrowEvents = new ArrayList<IIntermediateThrowEventBean>();
        choreographyTasks = new ArrayList<IChoreographyTaskBean>();
        subChoreographies = new ArrayList<ISubChoreographyBean>();
    }
    
    public void addFlowElement(IFlowElementBean flowElement){
    	
    	if (flowElement instanceof ISequenceFlowBean){
    		addSequenceFlow((ISequenceFlowBean) flowElement);
    	}else if(flowElement instanceof IStartEventBean){
    		addStartEvent((IStartEventBean) flowElement);
    	}else if (flowElement instanceof IEndEventBean){
    		addEndEvent((IEndEventBean) flowElement);
    	}else if (flowElement instanceof IGatewayBean){
    		addGateway((IGatewayBean) flowElement);
    	}else if (flowElement instanceof IIntermediateCatchEventBean){
    		addIntermediateCatchEvent((IIntermediateCatchEventBean) flowElement);
    	}else if (flowElement instanceof IIntermediateThrowEventBean){
    		addIntermediateThrowEvent((IIntermediateThrowEventBean) flowElement);
    	}else if (flowElement instanceof IChoreographyTaskBean){
    		addChoreographyTask((IChoreographyTaskBean) flowElement);
    	}else if (flowElement instanceof ISubChoreographyBean){
    		addSubChoreography( (ISubChoreographyBean) flowElement);
    	}
    	
    }
    
    public void addSubChoreography(ISubChoreographyBean s){
        if (subChoreographies.contains(s)==false) subChoreographies.add(s);
    }
    
    public void removeSubChoreography(ISubChoreographyBean s){
        subChoreographies.remove(s);
    }
    
    public void addChoreographyTask(IChoreographyTaskBean t){
        if (choreographyTasks.contains(t)==false){
        	choreographyTasks.add(t);
        	
        	for(IParticipantBean p:t.getParticipants()){
        		this.addParticipant(p);
        	}
        	
        	if (t.getInitiatingMessageFlow()!=null)	addMessageFlow(t.getInitiatingMessageFlow());
        	if (t.getReturnMessageFlow()!=null) 	addMessageFlow(t.getReturnMessageFlow());
        	
        }
    }
    
    public void removeChoreographyTask(IChoreographyTaskBean t){
        choreographyTasks.remove(t);
    }
    
    public void addSequenceFlow(ISequenceFlowBean s){
        if (sequenceFlows.contains(s)==false) sequenceFlows.add(s);
    }
    
    public void removeSequenceFlow(ISequenceFlowBean sf){
        sequenceFlows.remove(sf);
    }
    
    public void addStartEvent(IStartEventBean s){
        if (startEvents.contains(s)==false) startEvents.add(s);
    }
    
    public void addEndEvent(IEndEventBean e){
        if (endEvents.contains(e)==false) endEvents.add(e);
    }
    
    public void addGateway(IGatewayBean g){
        if (gateways.contains(g)==false) gateways.add(g);
    }
    
    public void addIntermediateCatchEvent(IIntermediateCatchEventBean e){
        if (intermediateCatchEvents.contains(e)==false) intermediateCatchEvents.add(e);
    }
    
    public void addIntermediateThrowEvent(IIntermediateThrowEventBean e){
        if (intermediateThrowEvents.contains(e)==false) intermediateThrowEvents.add(e);
    }
    
    public void removeStartEvent(IStartEventBean s){
        startEvents.remove(s);
    }

    public void removeEndEvent(IEndEventBean e){
        endEvents.remove(e);
    }

    public void removeGateway(IGatewayBean g){
        gateways.remove(g);
    }

    public void removeIntermediateCatchEvent(IIntermediateCatchEventBean e){
        intermediateCatchEvents.remove(e);
    }

    public void removeIntermediateThrowEvent(IIntermediateThrowEventBean e){
        intermediateThrowEvents.remove(e);
    }

    public IGatewayBean getGatewayById(String id){
        return searchListById(gateways,id);
    }
    
    public IStartEventBean getStartEventById(String id){
        return searchListById(startEvents,id);
    }
    
    public IEndEventBean getEndEventById(String id){
        return searchListById(endEvents,id);
    }
    
    public IIntermediateCatchEventBean getIntermediateCatchEventById(String id){
        return searchListById(intermediateCatchEvents,id);
    }
    
    public IIntermediateThrowEventBean getIntermediateThrowEventById(String id){
        return searchListById(intermediateThrowEvents, id);
    }
    
    private <T extends IFlowElementBean> T searchListById(List<T> l, String id){
        for(T t : l){
            if(t.getId().equals(id)){
                return t;
            }
        }
        return null;
    }
    @Override
    public List<IFlowElementBean> getFlowNodes(){
    	List<IFlowElementBean> nodes = null;
		nodes = new ArrayList<IFlowElementBean>();
		nodes.addAll(getEndEvents());
		nodes.addAll(getStartEvents());
		nodes.addAll(getChoreographyTasks());
		nodes.addAll(getGateways());
		nodes.addAll(getIntermediateCatchEvents());
		nodes.addAll(getIntermediateThrowEvents());
		nodes.addAll(getSubChoreographies());
		nodes.addAll(getSequenceFlows());
		return nodes;
    }
    
    public void cleanFlowNodes(){
    	getEndEvents().clear();
    	getStartEvents().clear();
    	getChoreographyTasks().clear();
    	getGateways().clear();
    	getIntermediateCatchEvents().clear();
    	getIntermediateThrowEvents().clear();
    	getSubChoreographies().clear();
    	getSequenceFlows().clear();
    }
    
    @Override
    public IFlowElementBean getFlowNode(String id){
    	for(IFlowElementBean fe : getFlowNodes()) {
    		if(fe.getId().equals(id)) {
    			return fe;
    		}
    	}
    	return null;
    }
    ////////////////////////////////////////////
    /////                                  /////
    /////       GETTERS AND SETTERS        /////
    /////                                  /////
    ////////////////////////////////////////////
    public List<ISequenceFlowBean> getSequenceFlows() {
        return sequenceFlows;
    }
    public void setSequenceFlows(List<ISequenceFlowBean> sequenceFlows) {
        this.sequenceFlows = sequenceFlows;
    }
    public List<IStartEventBean> getStartEvents() {
        return startEvents;
    }
    public void setStartEvents(List<IStartEventBean> startEvents) {
        this.startEvents = startEvents;
    }
    public List<IIntermediateCatchEventBean> getIntermediateCatchEvents() {
        return intermediateCatchEvents;
    }
    public void setIntermediateCatchEvents(List<IIntermediateCatchEventBean> intermediateCatchEvents) {
        this.intermediateCatchEvents = intermediateCatchEvents;
    }
    public List<IIntermediateThrowEventBean> getIntermediateThrowEvents() {
        return intermediateThrowEvents;
    }
    public void setIntermediateThrowEvents(List<IIntermediateThrowEventBean> intermediateThrowEvents) {
        this.intermediateThrowEvents = intermediateThrowEvents;
    }
    public List<IEndEventBean> getEndEvents() {
        return endEvents;
    }
    public void setEndEvents(List<IEndEventBean> endEvents) {
        this.endEvents = endEvents;
    }
    public List<IGatewayBean> getGateways() {
        return gateways;
    }
    public void setGateways(List<IGatewayBean> gateways) {
        this.gateways = gateways;
    }
    public List<IChoreographyTaskBean> getChoreographyTasks() {
        return choreographyTasks;
    }
    public void setChoreographyTasks(List<IChoreographyTaskBean> choreographyTasks) {
        this.choreographyTasks = choreographyTasks;
    }
    public List<ISubChoreographyBean> getSubChoreographies() {
        return subChoreographies;
    }
    public void setSubChoreographies(List<ISubChoreographyBean> subChoreographies) {
        this.subChoreographies = subChoreographies;
    }
    
}
