/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;

public class ErrorBean extends BaseElementBean implements IErrorBean {
    
    public static final String DEFAULT_ERROR_CODE = "Unspecified Error";

    private String name;
    private String errorCode;
    private IItemDefinitionBean structureRef;
    
    protected ErrorBean() {
        super();
    }
    
    public ErrorBean(String id) {
        super(id);
    }
    
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getErrorCode() {
        if(this.errorCode==null) {
            return DEFAULT_ERROR_CODE;
        }
        return errorCode;
    }
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
    public IItemDefinitionBean getStructureRef() {
        return structureRef;
    }
    public void setStructureRef(IItemDefinitionBean structureRef) {
        this.structureRef = structureRef;
    }

	public String toString() {
		return "["+this.getId()+":"+this.getName()+"]";
	}
    
}
