/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BPMNElementBean;

public class ImportBean extends BPMNElementBean implements IImportBean{

	/**
	 * Actual type in the api : java.net.URI
	 */
	private String location;
	/**
	 * Actual type in the api : java.net.URI
	 */
	private String importType;
	
	private INamespaceDeclaration nsDeclaration;
	
	protected ImportBean(){
		super();
	}
	
	public ImportBean(INamespaceDeclaration nsd){
		this.nsDeclaration = nsd;
	}
	
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getNamespace() {
		return nsDeclaration.getURI();
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	public String getImportType() {
		return importType;
	}
	public void setImportType(String importType) {
		this.importType = importType;
	}

	@Override
	public INamespaceDeclaration getNSDeclaration() {
		return nsDeclaration;
	}

	@Override
	public String getDisplayName() {
	    if(location==null) {
	        return getNamespace();
	    }
	    else {
	        int index = Math.max(location.lastIndexOf('/'), location.lastIndexOf('\\'));
	        if(index==-1) {
	            return location;
	        }
	        else {
	            return location.substring(index+1);
	        }
	    }
	}

	
}
