/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.IActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IIOSpecificationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IItemAwareElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.IOSpecificationBean;


public abstract class ActivityBean extends FlowNodeBean implements IActivityBean {

	private List<IDataAssociationBean> dataInputAssociations;
	private List<IDataAssociationBean> dataOutputAssociations;
	private ISequenceFlowBean defaultSequenceFlow;
	private IIOSpecificationBean ioSpecification;
	
	private Set<IItemAwareElementBean> dataInputs;
	private Set<IItemAwareElementBean> dataOutputs;
	
	public ActivityBean(String id){
		super(id);
		dataInputAssociations 	= new ArrayList<IDataAssociationBean>();
        dataOutputAssociations 	= new ArrayList<IDataAssociationBean>();
        ioSpecification			= new IOSpecificationBean(IdGenerator.createUniqueId());
        dataInputs				= new HashSet<IItemAwareElementBean>();
        dataOutputs				= new HashSet<IItemAwareElementBean>();
	}
	
	protected ActivityBean(){
		this(IdGenerator.createUniqueId());
	}
	
	
	public void setDefaultSequenceFlow(ISequenceFlowBean defaultSequenceFlow) {
		this.defaultSequenceFlow = defaultSequenceFlow;
	}
	
	public ISequenceFlowBean getDefaultSequenceFlow() {
		return defaultSequenceFlow;
	}
	
	public void addDataInputAssociation(IDataAssociationBean dia){
		if(dataInputAssociations==null){
			dataInputAssociations = new ArrayList<IDataAssociationBean>();
		}
		if (dataInputAssociations.contains(dia)==false) dataInputAssociations.add(dia);
	}
	
	public void addDataOutputAssociation(IDataAssociationBean doa){
		if(dataOutputAssociations==null){
			dataOutputAssociations = new ArrayList<IDataAssociationBean>();
		}
		if (dataOutputAssociations.contains(doa)==false) dataOutputAssociations.add(doa);
	}
	
	public void removeDataOutputAssociation(IDataAssociationBean doa){
		if(dataOutputAssociations!=null){
			dataOutputAssociations.remove(doa);
		}
	}
	
	public void removeDataInputAssociation(IDataAssociationBean dia){
		if(dataInputAssociations!=null){
			dataInputAssociations.remove(dia);
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IDataAssociationBean> getDataInputAssociations() {
		return dataInputAssociations;
	}
	public void setDataInputAssociations(
			List<IDataAssociationBean> dataInputAssociations) {
		this.dataInputAssociations = dataInputAssociations;
	}
	public List<IDataAssociationBean> getDataOutputAssociations() {
		return dataOutputAssociations;
	}
	public void setDataOutputAssociations(
			List<IDataAssociationBean> dataOutputAssociations) {
		this.dataOutputAssociations = dataOutputAssociations;
	}
	public IIOSpecificationBean getIoSpecification() {
		return ioSpecification;
	}
	public void setIoSpecification(IIOSpecificationBean ioSpecification) {
		this.ioSpecification = ioSpecification;
	}
	
	@Override
	public void addDataInput(IItemAwareElementBean source,IDataInputBean target) {
		this.dataInputs.add(source);
		
		//add data input in ioSpecification
		//DataInputBean dataInput = new DataInputBean("DataInput_"+this.getId()+"_"+data.getId());
		this.ioSpecification.addDataInput(target);
		
		if (this.getProcess()!=null){
			
			//if its a dataObject add it to current process
			if (source instanceof IDataObjectBean){
				
				IDataObjectBean dataObject = (IDataObjectBean) source;
				this.getProcess().addDataObject(dataObject);
				
			//if its a dataInput/dataOuput add it to current processes ioSpecification				
			}else if (source instanceof IDataInputBean){
	
				IDataInputBean dinput = (IDataInputBean) source;
				this.getProcess().getIoSpecification().addDataInput(dinput);
				
			}else if(source instanceof IDataOutputBean){
				
				IDataOutputBean doutput = (IDataOutputBean) source;
				this.getProcess().getIoSpecification().addDataOutput(doutput);
				
			}
			
		}
		
		
	}
	
	
	@Override
	public void addDataOutput(IDataOutputBean source,IItemAwareElementBean target) {
		this.dataOutputs.add(target);

		this.ioSpecification.addDataOutput(source);
		
		if (this.getProcess()!=null){
			
			//if its a dataObject add it to current process
			if (target instanceof IDataObjectBean){
				
				IDataObjectBean dataObject = (IDataObjectBean) target;
				
				this.getProcess().addDataObject(dataObject);
				
			//if its a dataInput/dataOuput add it to current processes ioSpecification				
			}else if (target instanceof IDataInputBean){
	
				IDataInputBean dinput = (IDataInputBean) target;
				this.getProcess().getIoSpecification().addDataInput(dinput);
				
			}else if(target instanceof IDataOutputBean){
				
				IDataOutputBean doutput = (IDataOutputBean) target;
				this.getProcess().getIoSpecification().addDataOutput(doutput);
				
			}
			
		}
		
	}
	
	public Set<IItemAwareElementBean> getDataInputs() {
		return dataInputs;
	}
	
	@Override
	public Set<IItemAwareElementBean> getDataOutputs() {
		return dataOutputs;
	}
	
	public void setDataInputs(Set<IItemAwareElementBean> dataInputs) {
		this.dataInputs = dataInputs;
	}
	
	public void setDataOutputs(Set<IItemAwareElementBean> dataOutputs) {
		this.dataOutputs = dataOutputs;
	}
}
