/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient;

import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.ImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.WSDLImportBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ImportAdapter;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.junit.Assert;
import org.junit.Test;

public class ImportAdapterTest {
    @Test
    public void WSDLImportTest() throws XmlObjectReadException, XPathExpressionException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/A.wsdl");
        Definitions defs = (Definitions)new XmlContextFactory().newContext().createReader().readDocument(url, Definitions.class);
        XmlObjectXPathEvaluator xpe = defs.getXmlContext().createXPathEvaluator();
        String prefix = "prefix";
        String location = "location";
        ImportBean impt = ImportAdapter.adaptWSDLImport((String)prefix, (String)location, (Definitions)defs);
        Assert.assertTrue((boolean)(impt instanceof WSDLImportBean));
        Assert.assertEquals((Object)prefix, (Object)impt.getNSDeclaration().getPrefix());
        Assert.assertEquals((Object)location, (Object)impt.getLocation());
        Assert.assertEquals((Object)defs.getTargetNamespace(), (Object)impt.getNamespace());
        WSDLImportBean wsdlImpt = (WSDLImportBean)impt;
        Assert.assertEquals((long)defs.getPortTypes().length, (long)wsdlImpt.getInterfaces().size());
        for (IInterfaceBean itf : wsdlImpt.getInterfaces()) {
            Assert.assertNull((Object)itf.getNSDeclaration());
            String implemRef = "{" + defs.getTargetNamespace() + "}" + itf.getName();
            Assert.assertEquals((Object)implemRef, (Object)itf.getWsdlImplementationRef());
            PortType pt = (PortType)xpe.selectSingleXmlObjectNode((XmlObject)defs, "//*[@name=\"" + itf.getName() + "\"]", PortType.class);
            Assert.assertNotNull((Object)pt);
            Assert.assertEquals((long)pt.getOperations().length, (long)itf.getOperations().size());
        }
        Assert.assertNotNull((Object)wsdlImpt.getItemDefinitions());
        Assert.assertEquals((long)4L, (long)wsdlImpt.getItemDefinitions().size());
        for (IItemDefinitionBean itemDef : wsdlImpt.getItemDefinitions()) {
            Assert.assertNull((Object)itemDef.getNSDeclaration());
            Assert.assertNotNull((Object)itemDef.getStructureRef());
        }
    }
}

