/**
 * Web commons : user service.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UserDAOImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.persistence.dao;

import org.hibernate.SessionFactory;

import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.ebmwebsourcing.webcommons.user.persistence.bo.User;
import com.trg.search.Filter;
import com.trg.search.Search;

/**
 * @author strino - eBM WebSourcing
 * 
 */
public class UserDAOImpl extends GenericHibernateDAOImpl<User, String> implements UserDAO {

    public UserDAOImpl(SessionFactory factory) {
        super(factory);
    }

    // retrieve user by its name
    public User getUserByName(String name) {
        Search search = new Search();
        search.addFilterAnd(Filter.equal("name", name));
        search.addSortAsc("name");
        return searchUnique(search);
    }

}
