/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.aop;

import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LogPublicMethodOfPersistenceCall {
    private final Logger logger = Logger.getLogger(LogPublicMethodOfPersistenceCall.class);

    @Pointcut(value="within(com.ebmwebsourcing.webcommons.user.persistence..*) && execution(public * *(..))")
    private void allPublicMethodOfPersistence() {
    }

    @Around(value="allPublicMethodOfPersistence()")
    public Object beforePublicAllArgsNotNull(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        String methodName = pjp.getSignature().getName();
        if (this.logger.isTraceEnabled()) {
            StringBuffer methodCallLog = new StringBuffer("Call method '").append(methodName).append("' with params : ");
            for (int i = 0; i < args.length; ++i) {
                methodCallLog.append(args[i]).append(" ");
            }
            this.logger.trace((Object)methodCallLog.toString());
        } else if (this.logger.isDebugEnabled()) {
            StringBuffer methodCallLog = new StringBuffer("Call method '").append(methodName);
            this.logger.debug((Object)methodCallLog.toString());
        }
        return pjp.proceed();
    }
}

