package com.ebmwebsourcing.webcommons.util;


import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

public class JAXBUtil {
    @SuppressWarnings("unchecked")
    public static JAXBContext createJAXBContext(List<Class> defaultObjectFactories)
            throws JAXBException {
        return createJAXBContext(defaultObjectFactories.toArray(new Class[defaultObjectFactories
                .size()]));
    }

    @SuppressWarnings("unchecked")
    public static JAXBContext createJAXBContext(Class... defaultObjectFactories)
            throws JAXBException {
        return JAXBContext.newInstance(defaultObjectFactories);
    }

    public static JAXBContext createJAXBContextFromPackages(String... packages)
            throws JAXBException {
        String allPackages = "";
        for (String pack : packages) {
            allPackages += pack;
        }
        return JAXBContext.newInstance(allPackages);
    }

    public static JAXBContext createJAXBContextFromPackages(String packages) throws JAXBException {
        return JAXBContext.newInstance(packages);
    }

    public static JAXBContext createJAXBContextFromPackages(List<String> packages)
            throws JAXBException {
        return createJAXBContextFromPackages(packages.toArray(new String[packages.size()]));
    }

    public static SchemaFactory createSchemaFactory(String xsdLocation) throws JAXBException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        try {
            factory.newSchema(new StreamSource[] { new StreamSource(InputStreamUtil
                    .getInputStream(xsdLocation)) });
        } catch (Exception e) {
            throw new JAXBException("Can't create JAXB Factory from xsd '" + xsdLocation, e);
        }
        return factory;
    }

}
