/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.wsstar.addressing.definition.decorator;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.neethi.Policy;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaElement;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@SuppressWarnings("unchecked")
public class DecoratorEndpointReferenceTypeImpl<Ref extends AbsItfReferenceParametersType> extends AbstractSchemaElementImpl implements Decorator {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	protected AbsItfEndpointReferenceType<Ref> epr;


	public DecoratorEndpointReferenceTypeImpl(AbsItfEndpointReferenceType<Ref> epr)
	throws WSAddressingException {
		super();
		this.epr = epr;
		this.model = ((AbstractSchemaElementImpl)this.getFirstEpr()).getModel();
		
	}

	public EndpointReferenceType getFirstEpr() {
		EndpointReferenceType res = null;
		AbsItfEndpointReferenceType tmp = this.epr;
		while ((tmp != null) && (tmp instanceof DecoratorEndpointReferenceTypeImpl)) {
			tmp = ((DecoratorEndpointReferenceTypeImpl) tmp).getFirstEpr();
		}
		if (tmp instanceof EndpointReferenceType) {
			res = (EndpointReferenceType) tmp;
		}
		return res;
	}


	@Override
	public Object getModel() {
		return ((AbstractSchemaElementImpl)this.getFirstEpr()).getModel();
	}

	@Override
	public AbstractSchemaElementImpl getParent() {
		return ((AbstractSchemaElementImpl)this.epr).getParent();
	}

	public SchemaElement getDecorator() {
		return this.epr;
	}

	public String getAddress() {
		return this.epr.getAddress();
	}

	public URI getDocumentBaseURI() {
		return this.epr.getDocumentBaseURI();
	}

	public List<Policy> getPolicies() {
		return this.epr.getPolicies();
	}

	public Ref getReferenceParameters()
	throws WSAddressingException {
		return this.epr.getReferenceParameters();
	}

	public Ref newReferenceParameters()
	throws WSAddressingException {
		return this.epr.newReferenceParameters();
	}

	public QName getTagQName() {
		return this.epr.getTagQName();
	}

	public void setAddress(String address) {
		this.epr.setAddress(address);
	}

	public void setDocumentBaseURI(URI documentBaseURI) {
		this.epr.setDocumentBaseURI(documentBaseURI);
	}

	public void setPolicy(List<Policy> policies) throws WSAddressingException {
		this.epr.setPolicy(policies);
	}

	public void setReferenceParameters(Ref ref) throws WSAddressingException {
		this.epr.setReferenceParameters(ref);
	}

	public void setTagQName(QName name) {
		this.epr.setTagQName(name);
	}


}
