package com.ebmwebsourcing.agreement.definition.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.agreement.definition.api.ServiceDescription;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

public class ServiceDescriptionImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceDescriptionTermType> implements ServiceDescription {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ServiceDescriptionImpl.class.getName());

	private sla.ebmwebsourcing.com.agreementextensions.ObjectFactory factory = new sla.ebmwebsourcing.com.agreementextensions.ObjectFactory();

	public ServiceDescriptionImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceDescriptionTermType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);
	}



	public URI getWsdlDescription() {
		URI res = null;
		try {
			if(this.model.getAny() instanceof JAXBElement) {
				if(((JAXBElement)this.model.getAny()).getValue() instanceof String) {
					res = new URI((String) ((JAXBElement)this.model.getAny()).getValue());
				}
			}
		} catch (URISyntaxException e) {
			// do nothing
			log.severe(e.getMessage());
		}
		return res;
	}



	public void setWsdlDescription(URI wsdl) {
		this.model.setAny(factory.createWsdlUri(wsdl.toString()));
	}



	public String getName() {
		return this.model.getName();
	}



	public String getServiceName() {
		return this.model.getServiceName();
	}



	public void setName(String name) {
		this.model.setName(name);
	}



	public void setServiceName(String servName) {
		this.model.setServiceName(servName);
	}


}
