package com.ebmwebsourcing.wsstar.agreement.service.impl;

import java.util.UUID;

import org.w3c.dom.Document;

import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.AgreementTemplate;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle.State;
import com.ebmwebsourcing.wsstar.agreement.service.api.AgreementService;

public class AgreementServiceImpl implements AgreementService {

	private WSAgreementFactory factory = null;
	
	public AgreementServiceImpl() throws WSAgreementException {
		this.factory = WSAgreementFactory.newInstance();
	}
	public Agreement createClientAgreement() throws WSAgreementException {
		return this.factory.newAgreement();
	}


	public AgreementTemplate createProviderAgreementTemplate() throws WSAgreementException {
		AgreementTemplate template = this.factory.newAgreementTemplate();
		
		// set template id
		template.setTemplateId(UUID.randomUUID().toString());
		
		return template;
	}
	
	public Agreement createClientAgreementFromProviderTemplate(
			AgreementTemplate template) throws WSAgreementException {
		Agreement ag = this.factory.newAgreement();
		
		// copy name
		ag.setName(template.getName());
		
		// copy context
		ag.setContext(template.getContext());
		ag.getContext().setTemplateId(template.getTemplateId());
		ag.getContext().setTemplateName(template.getName());
		
		// copy service description
		ag.setServiceDescription(template.getServiceDescription());
		
		// copy service reference
		ag.setServiceReference(template.getServiceReference());
		
		// copy service properties
		ag.setServiceProperties(template.getServiceProperties());
		
		// copy guarantee
		ag.setGuaranteeTerms(template.getGuaranteeTerms());
		
		// clean parent hierarchy
		Document doc = factory.newWSAgreementWriter().getDocument(ag);
		ag = factory.newWSAgreementReader().readAgreement(doc);
		
		return ag;
	}
	
	public Agreement acceptClientAgreement(Agreement required,
			AgreementTemplate offer) {
		
		// start acceptation process
		((AgreementLifeCycle)required).setState(State.PENDING);
		
		// match the required agreement from the offer agreement
		boolean match = this.match(required, offer);
		
		// change state
		if(match) {
			((AgreementLifeCycle)required).setState(State.OBSERVE);
		} else {
			((AgreementLifeCycle)required).setState(State.REJECTE);
		}
		
		return required;
	}

	public boolean match(Agreement required, AgreementTemplate offer) {
		// TODO: implement match method
		return false;
	}


}
