/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.api;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.SchemaElement;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public interface NotificationMessageHolderType extends SchemaElement {
	
	public static final String NOTIFY_CONTENT_URI = "http://www.ebmwebsourcing.com/WS-BaseNotification/NotifyContent";
	public static final String NOTIFY_CONTENT_PREFIX = "wsnebm";
	public static final String NOTIFY_CONTENT_LOCALPART = "NotifyContent";
	public static final QName NOTIFY_CONTENT_QNAME = new QName(NOTIFY_CONTENT_URI,NOTIFY_CONTENT_LOCALPART,NOTIFY_CONTENT_PREFIX);
	
	public EndpointReferenceType getSubscriptionReference() throws WSNotificationException;
	
	public void setSubscriptionReference(EndpointReferenceType ref);
	
	public EndpointReferenceType getProducerReference() throws WSNotificationException;
	
	public void setProducerReference(EndpointReferenceType ref);
	
	public TopicExpressionType getTopic() throws WSNotificationException;
	
	public void setTopic(TopicExpressionType value);
	
	public Message getMessage();
	
	public void setMessage(Message value);
		
}
