/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.inout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.WsnbrConstants;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.topics.WstopConstants;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationJAXBContext;

/**
 * This class implements the {@link WSNotificationWriter} java interface
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class WSNotificationWriterImpl implements WSNotificationWriter {

	private static Logger log = Logger.getLogger(WSNotificationWriterImpl.class.getName());
	
    private WSNotificationJAXBContext notifJaxbContext = null;
    
    private String[] nsAndPrefixForMarshalling = null;

    /**
     * Default constructor
     * 
     * @throws WSNotificationException
     */
    public WSNotificationWriterImpl() throws WSNotificationException {
		try {
			notifJaxbContext = new WSNotificationJAXBContext();
		} catch (Exception e) {
			throw new WSNotificationException(e);
		}	
	}
     
    /**
     * Constructor called to provide a custom "prefix/namespace" mapping 
     * 
     * @param nsAndPrefixForMarshalling
     * @throws WSNotificationException
     */
    public WSNotificationWriterImpl(String[] nsAndPrefixForMarshalling) throws WSNotificationException {
		try {
			notifJaxbContext = new WSNotificationJAXBContext();
			notifJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);
		} catch (Exception e) {
			throw new WSNotificationException(e);
		}	
	}
       
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#WriteNotify(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify)
     */
    public Document writeNotify(Notify notifyObj)
    		throws WSNotificationException {
    	Document result = null;
    	try {
    	
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		// get from corresponding TopicExpression model object, topicNS to add to Document result object.
    		List<List<QName>> topicNSToAdd = new ArrayList<List<QName>>();
    		
    		List<NotificationMessageHolderType> notifMessages = notifyObj.getNotificationMessage(); 
			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
				topicNSToAdd.add(notifMsgItem.getTopic().getTopicNameSpace());
				// remove (temporarily) namespace from java object  
				((TopicExpressionTypeImpl)notifMsgItem.getTopic()).removeTopicNSFromModel();
			}			
    	
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Notify> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Notify>(WsnbConstants.NOTIFY_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.base.Notify.class, (com.ebmwebsourcing.wsstar.notification.definition.base.Notify)
    					((AbstractSchemaElementImpl<?>)notifyObj).getModel());

    		marshaller.marshal(element, result);
    		
    		   	
    		// just convert:
            // TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(result);
	    							
			//For each NotificationMessage node, get its Topic Node and "add" topicNS
			List<?> notifMsgNodes = docAsJDom.getRootElement().getChildren(WsnbConstants.NOTIFICATION_MSG_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbConstants.NOTIFICATION_MSG_QNAME.getNamespaceURI()));

			Element currentTopicNode = null;
			for (Object msgNode : notifMsgNodes) {
				currentTopicNode = ((Element)msgNode).getChild(WsnbConstants.TOPIC_QNAME.getLocalPart(),
						Namespace.getNamespace(WsnbConstants.TOPIC_QNAME.getNamespaceURI()));
				List<QName> currentTopicsToAdd = topicNSToAdd.get(notifMsgNodes.indexOf(msgNode));
				for (QName nsItem : currentTopicsToAdd) {
					currentTopicNode.addNamespaceDeclaration(Namespace.getNamespace(nsItem.getLocalPart(), nsItem.getNamespaceURI()));
				}
			}
    		
			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );
   			
   			// --- restore namespaces, previously remove, on java object
   			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
    			for (QName qnItem : topicNSToAdd.get(notifMessages.indexOf(notifMsgItem))) {    		
    				((TopicExpressionTypeImpl)notifMsgItem.getTopic()).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
    			} 
    		}
   			

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (JDOMException exJDom) {
     	   throw new WSNotificationException(
                   "Dom <--> JDom conversion failed !", exJDom);
    	}      

    	return result;
    }

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeRegisterPublisher(com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher)
     */
    public Document writeRegisterPublisher(RegisterPublisher regPubObj)
    		throws WSNotificationException {
    	Document result = null;
    	try {

    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		List<List<QName>> additianalTopicNSPerExp = new ArrayList<List<QName>>(); 

    		List<TopicExpressionType> topicExprList = regPubObj.getTopic();
    		for (TopicExpressionType topExprItem : topicExprList) {
    			additianalTopicNSPerExp.add(topExprItem.getTopicNameSpace());
    			// remove (temporarily) namespace from java object  
    			((TopicExpressionTypeImpl)topExprItem).removeTopicNSFromModel();
    		}    		 
      		      		
      		// Process Marshalling operation : 
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher>(WsnbrConstants.REGISTER_PUBLISHER_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher) 
    					((AbstractSchemaElementImpl<?>)regPubObj).getModel());

    		marshaller.marshal(element, result);            

    		 // just convert:
            // TODO : replace JDOM and DOM with StaxSource   
   			DOMBuilder builder = new DOMBuilder();
   			org.jdom.Document docAsJDom = builder.build(result);
   			
   			List<?> topicExprNodes = docAsJDom.getRootElement().getChildren(WsnbrConstants.TOPIC_QNAME.getLocalPart(),
   					Namespace.getNamespace(WsnbrConstants.TOPIC_QNAME.getNamespaceURI()));
   			
   			for (Object topExpNodeItem : topicExprNodes) {   				
   				for (QName nsToAddItem : additianalTopicNSPerExp.get(topicExprNodes.indexOf(topExpNodeItem))) {
   					((Element)topExpNodeItem).addNamespaceDeclaration(Namespace.getNamespace(nsToAddItem.getLocalPart(), nsToAddItem.getNamespaceURI()));
   				}
			}
   			//for (List<QName> currentNSList : additianalTopicNSPerExp) {
   				//Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
   				//docAsJDom.getRootElement().addNamespaceDeclaration(topicNS);
   			//}

   			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );    		   			   		 
    	
   			// --- restore namespace on java object
    		for (TopicExpressionType topExprItem : topicExprList) {
    			for (QName qnItem : additianalTopicNSPerExp.get(topicExprList.indexOf(topExprItem))) {    		
    				((TopicExpressionTypeImpl)topExprItem).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
    			} 
    		}
    		   			   		    		
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (JDOMException exJDom) {
     	   throw new WSNotificationException(
                   "Dom <--> JDom conversion failed !", exJDom);
    	}     
    	return result;
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeRegisterPublisher(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher)
     */
    public Document writeRegisterPublisherResponse(RegisterPublisherResponse regPubRespObj)
    		throws WSNotificationException {
    	Document result = null;
    	 try {
    		 
    		 Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		 
             result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            
             // TODO : Check if it is a Thread safe method
             final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse>(WsnbrConstants.REGISTER_PUBLISHER_RESPONSE_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse) 
                		 ((AbstractSchemaElementImpl<?>)regPubRespObj).getModel());
             
             marshaller.marshal(element, result);            
             
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } 
    	    
    	return result;
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeDestroyRegistration(com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration)
     */
    public Document writeDestroyRegistration(DestroyRegistration destRegObj)
    		throws WSNotificationException {
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration>(WsnbrConstants.DESTROY_REGISTRATION_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration)
    					((AbstractSchemaElementImpl<?>)destRegObj).getModel());

    		marshaller.marshal(element, result);            

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} 
    	return result;    	
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeDestroyRegistrationResponse(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse)
     */
    public Document writeDestroyRegistrationResponse(DestroyRegistrationResponse destRegRespObj)
    throws WSNotificationException {
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse>(WsnbrConstants.DESTROY_REGISTRATION_RESPONSE_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse)
    					((AbstractSchemaElementImpl<?>)destRegRespObj).getModel());

    		marshaller.marshal(element, result);            

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} 

    	return result;
    }

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeSubscribe(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe)
     */
    public Document writeSubscribe(Subscribe subsObj)
    		throws WSNotificationException {
    	Document result = null;
      	 try {

      		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
      		 
      		 List<QName> additianalTopicNS = subsObj.getFilter().getTopicExpression().getTopicNameSpace();
      		 // remove (temporarily) namespace from java object  
      		 ((TopicExpressionTypeImpl)subsObj.getFilter().getTopicExpression()).removeTopicNSFromModel();
      	
      		 
               result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
               // TODO : Check if it is a Thread safe method
               final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe> element = 
                   new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe>(WsnbConstants.SUBSCRIBE_QNAME,
                  		 com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.class,(com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe) 
                  		 ((AbstractSchemaElementImpl<?>)subsObj).getModel());               
               marshaller.marshal(element, result);
                              
            // just convert:
               // TODO : replace JDOM and DOM with StaxSource   
      			DOMBuilder builder = new DOMBuilder();
      			org.jdom.Document docAsJDom = builder.build(result);
      			
      			for (QName currentNS : additianalTopicNS) {
      				Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
      				docAsJDom.getRootElement().getChild(WsnbConstants.FILTER_QNAME.getLocalPart(),
      						Namespace.getNamespace(WsnbConstants.FILTER_QNAME.getNamespaceURI())).getChild(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart(),
      								Namespace.getNamespace(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI())).addNamespaceDeclaration(topicNS);
      			}
      			
      			// just convert:
               // TODO : replace JDOM and DOM with StaxSource
      			DOMOutputter putter = new DOMOutputter ();
      			result = putter.output( docAsJDom );
                     			
      			// --- restore namespace on java object
      			for (QName qnItem : additianalTopicNS) {			
      				((TopicExpressionTypeImpl)subsObj.getFilter().getTopicExpression()).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
      			}	
      			
      			
           } catch (final JAXBException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           } catch (final ParserConfigurationException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           }catch (JDOMException exJDom) {
        	   throw new WSNotificationException(
        			   "Dom <--> JDom conversion failed !", exJDom);
           }         	    
      	return result;
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeSubscribeResponse(com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse)
     */
    public Document writeSubscribeResponse(SubscribeResponse subsRepObj)
    throws WSNotificationException {
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
             // TODO : Check if it is a Thread safe method
             final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse>(WsnbConstants.SUBSCRIBE_RESPONSE_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse)
                		 ((AbstractSchemaElementImpl<?>)subsRepObj).getModel());
             marshaller.marshal(element, result);
                         
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }         
    	
    	return result;
    }
    
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeUnsubscribe(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe)
     */
    public Document writeUnsubscribe(Unsubscribe unsubsObj)
    		throws WSNotificationException {
    	Document result = null;
     	 try {
     		 
     		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
     		 
     		 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
              // TODO : Check if it is a Thread safe method
              final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe> element = 
                  new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe>(WsnbConstants.UNSUBSCRIBE_QNAME,
                 		 com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe.class,(com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe) 
                 		 ((AbstractSchemaElementImpl<?>)unsubsObj).getModel());               
              marshaller.marshal(element, result);                           
          } catch (final JAXBException ex) {
              throw new WSNotificationException(
                      "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
          } catch (final ParserConfigurationException ex) {
              throw new WSNotificationException(
                      "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
          }       	    
     	return result;
    }
    
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeUnsubscribeResponse(com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse)
	 */
	public Document writeUnsubscribeResponse(UnsubscribeResponse unsubsRespObj)
			throws WSNotificationException {
		Document result = null;
    	
   	 try {
   		 
   		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            // TODO : Check if it is a Thread safe method
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse> element = 
                new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse>(WsnbConstants.UNSUBSCRIBE_RESPONSE_QNAME,
                		com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse)
                		((AbstractSchemaElementImpl<?>)unsubsRespObj).getModel());
            marshaller.marshal(element, result);
                        
        } catch (final JAXBException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        }            	
   	return result;		
	}

    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeSubscriptionToFile(com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP, java.io.File)
     */
    public void writeSubscriptionToFile(SubscriptionManagerRP subscription,
    		File file) throws WSNotificationException {
    	 try {
    		 Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		 
    		 final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP>(WsnbConstants.SUBSCRIPTION_MGR_RP_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP.class,(com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP)
                		 ((AbstractSchemaElementImpl<?>)subscription).getModel());
    		 marshaller.marshal(element, file);
             
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to marshall " + SubscriptionManagerRP.class.getSimpleName()
                    + " Object from SchemaImpl descriptor Java classes, to file : \n\t" +
                    file.getAbsolutePath() + "\n", ex);
         }         
    	
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeTopicExpressionType(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType)
     */
    public Document writeTopicExpressionType(TopicExpressionType topicExpression)
    		throws WSNotificationException {
    	Document result = null;    
    	
      	 try {
        
      		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
      		 
      		 List<QName> additianalTopicNS = topicExpression.getTopicNameSpace();
      		 // remove (temporarily) namespace from java object  
      		 ((TopicExpressionTypeImpl)topicExpression).removeTopicNSFromModel();
      		 
      		 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();                              
               // TODO : Check if it is a Thread safe method
               final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> element = 
                   new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType>(WsnbConstants.TOPIC_EXPRESSION_QNAME,
                   		com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType.class,(com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType)
                   		((AbstractSchemaElementImpl<?>)topicExpression).getModel());
               marshaller.marshal(element, result);

            // just convert:
            // TODO : replace JDOM and DOM with StaxSource   
   			DOMBuilder builder = new DOMBuilder();
   			org.jdom.Document docAsJDom = builder.build(result);
   			
   			for (QName currentNS : additianalTopicNS) {
   				Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
   				docAsJDom.getRootElement().addNamespaceDeclaration(topicNS);
   			}

   			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );
   			
   			// --- restore namespace on java object
   			for (QName qnItem : additianalTopicNS) {			
  				((TopicExpressionTypeImpl)topicExpression).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
  			}	
   			
   			
   		            
           } catch (final JAXBException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           } catch (final ParserConfigurationException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           } catch (JDOMException exJDom) {
        	   throw new WSNotificationException(
        			   "Dom <--> JDom conversion failed !", exJDom);
           }            	          
           return result;		
    }

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeQueryExpressionType(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType)
     */
    public Document writeQueryExpressionType(QueryExpressionType queryExpression)
    throws WSNotificationException {
    	Document result = null;    

    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();                              
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType>(WsnbConstants.TOPIC_EXPRESSION_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType.class,(com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType)
    					((AbstractSchemaElementImpl<?>)queryExpression).getModel());
    		marshaller.marshal(element, result);

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	}          	          
    	return result;		
    }

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeTopicType(com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType)
     */
    public Document writeTopicType(TopicType topic) throws WSNotificationException {
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType>(WstopConstants.TOPIC_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType.class,(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType) 
    					((AbstractSchemaElementImpl<?>)topic).getModel());               
    		marshaller.marshal(element, result);                           
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	}       	    
    	return result;
    }

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeTopicNamespaceType(com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType)
     */
    public Document writeTopicNamespaceType(TopicNamespaceType namespace) throws WSNotificationException {
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType>(WstopConstants.TOPICNAMESPACE_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.class,(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType) 
    					((AbstractSchemaElementImpl<?>)namespace).getModel());               
    		marshaller.marshal(element, result);                           
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }       	    
    	return result;
    }

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationWriter#writeTopicSetType(com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType)
     */
	public Document writeTopicSetType(TopicSetType topicSet)
			throws WSNotificationException {
		Document result = null;
   	 try {
   		 
   		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
   		
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
            // TODO : Check if it is a Thread safe method
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType> element = 
                new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType>(WstopConstants.TOPICSET_QNAME,
               		 com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType.class,(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType) 
               		 ((AbstractSchemaElementImpl<?>)topicSet).getModel());               
            marshaller.marshal(element, result);                           
        } catch (final JAXBException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        }       	    
   	return result;
	}
}
