/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.notification.definition;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.definition.basefaults.api.BaseFaultDescriptionType;
import com.ebmwebsourcing.wsstar.notification.definition.basefaults.api.BaseFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basefaults.impl.BaseFaultDescriptionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basefaults.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidFilterFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidMessageContentExpressionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidProducerPropertiesExpressionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidTopicExpressionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.MultipleTopicsSpecifiedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NoCurrentMessageOnTopicFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotifyMessageNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.PauseFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.ResumeFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeCreationFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionDialectUnknownFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToCreatePullPointFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToDestroyPullPointFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToDestroySubscriptionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToGetMessagesFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableInitialTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnrecognizedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsupportedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.FilterTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.GetCurrentMessageImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.GetCurrentMessageResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.InvalidFilterFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.InvalidMessageContentExpressionFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.InvalidProducerPropertiesExpressionFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.InvalidTopicExpressionFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.MultipleTopicsSpecifiedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NoCurrentMessageOnTopicFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NotificationMessageHolderTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NotifyImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NotifyMessageNotSupportedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.PauseFailedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.QueryExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.RenewImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.RenewResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.ResumeFailedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeCreationFailedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscriptionManagerRPImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscriptionPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionDialectUnknownFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicNotSupportedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnableToDestroyPullPointFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnableToDestroySubscriptionFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnableToGetMessagesFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnacceptableInitialTerminationTimeFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnacceptableTerminationTimeFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnrecognizedPolicyRequestFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsubscribeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsupportedPolicyRequestFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.DestroyRegistrationImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.DestroyRegistrationResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.PublisherRegistrationFailedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.PublisherRegistrationRPImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.PublisherRegistrationRejectedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.RegisterPublisherImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.RegisterPublisherResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.ResourceNotDestroyedFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.UnableToCreatePullPointFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.resource.api.ResourceUnknownFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.resource.impl.ResourceUnknownFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicNamespaceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

/**
 * This class is a concrete implementation of the abstract class WSNotificationFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WSNotificationFactoryImpl extends WSNotificationFactory {

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createWSNotificationReader()
	 */
    /*@Override
    public WSNotificationReader createWSNotificationReader() throws WSNotificationException {
        final WSNotificationReader reader = new WSNotificationReaderImpl();
        return reader;
    }*/

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createWSNotificationWriter()
     */
    /*@Override
    public WSNotificationWriter createWSNotificationWriter() throws WSNotificationException {
    	final WSNotificationWriter writer = new WSNotificationWriterImpl();
    	return writer;
    }*/

   
   /*
    * (non-Javadoc)
    * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createWSNotificationWriter(java.lang.String[])
    */
   /* @Override
    public WSNotificationWriter createWSNotificationWriter(String[] namespaceAndPrefixList) throws WSNotificationException {
    	final WSNotificationWriter writer = new WSNotificationWriterImpl(namespaceAndPrefixList);
    	return writer;
    }*/
    
    //################# ADDED BY TDEJEAN ###################

    // ======= Common =======
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createStringJaxbElt(javax.xml.namespace.QName, java.lang.String)
     */
    @Override
    public JAXBElement<String> createStringJaxbElt(QName qname, String value){    	
    	JAXBElement<String> result = null;
    	if (value != null)
    		result = new JAXBElement<String>(qname,String.class,value);
    	return result;
    }
	// ===========================================
    
    // ============= WS-Resource =================
    // ~~~ WS-Resource faults ~~~
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createResourceUnknownFault(com.ebmwebsourcing.wsstar.notification.definition.resource.api.ResourceUnknownFaultType)
     */
	@Override
	public JAXBElement<?> createResourceUnknownFault(
			ResourceUnknownFaultType fault) throws WSNotificationException {
		return this.wsrfrwFactory.createResourceUnknownFault((com.ebmwebsourcing.wsstar.notification.definition.resource.ResourceUnknownFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());	
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createResourceUnknownFaultType()
	 */
	@Override
	public ResourceUnknownFaultType createResourceUnknownFaultType()
			throws WSNotificationException {
		//return this.wsrfrwFactory.createResourceUnknownFaultType();
		return new ResourceUnknownFaultTypeImpl(this.wsrfrwFactory.createResourceUnknownFaultType(),null);
	}
	// ============================================

    // ============= WS-BaseFaults ================	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createBaseFaultType()
	 */
    @Override
    public BaseFaultType createBaseFaultType() throws WSNotificationException {
    	return new BaseFaultTypeImpl(this.wsrfbfFactory.createBaseFaultType(), null);
    }
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createBaseFaultDescriptionType()
     */
	@Override
	public BaseFaultDescriptionType createBaseFaultDescriptionType()
			throws WSNotificationException {
		return new BaseFaultDescriptionTypeImpl(this.wsrfbfFactory.createBaseFaultTypeDescription(),
				(BaseFaultTypeImpl)this.createBaseFaultType());
	}
	//	===================================
    
    // ============ WS-Topics ============	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicType()
	 */
	@Override
    public TopicType createTopicType() throws WSNotificationException {
    	return new TopicTypeImpl(this.wstopFactory.createTopicType(),null);
    }
    
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicNamespaceType()
	 */
    @Override
    public TopicNamespaceType createTopicNamespaceType() throws WSNotificationException {
    	return new TopicNamespaceTypeImpl(this.wstopFactory.createTopicNamespaceType(),null);
    }
    
    /*
    @Override
    public TopicSetType createTopicSetType() throws WSNotificationException {
    	return this.wstopFactory.createTopicSetType();
    }
    */
    // =====================================================
    
    // ============= WS-BaseNotification Part ==============     	
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createNotify()
     */
    @Override
	public Notify createNotify() throws WSNotificationException {
		return new NotifyImpl(this.wsnbFactory.createNotify(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createSubscribe()
	 */
	@Override
	public Subscribe createSubscribe() throws WSNotificationException {
		return new SubscribeImpl(this.wsnbFactory.createSubscribe(),null);
	}
    
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createSubscribeResponse()
	 */
    @Override
    public SubscribeResponse createSubscribeResponse() throws WSNotificationException {
    	return new SubscribeResponseImpl(this.wsnbFactory.createSubscribeResponse(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createGetCurrentMessage()
     */
    @Override
    public GetCurrentMessage createGetCurrentMessage()
    		throws WSNotificationException {    	
    	return new GetCurrentMessageImpl(this.wsnbFactory.createGetCurrentMessage(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createGetCurrentMessageResponse()
     */
    @Override
    public GetCurrentMessageResponse createGetCurrentMessageResponse()
    		throws WSNotificationException {    
    	return new GetCurrentMessageResponseImpl(this.wsnbFactory.createGetCurrentMessageResponse(), null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnsubscribe()
     */
    @Override
	public Unsubscribe createUnsubscribe() throws WSNotificationException {
    	return new UnsubscribeImpl(this.wsnbFactory.createUnsubscribe(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnsubscribeResponse()
     */
    @Override
    public UnsubscribeResponse createUnsubscribeResponse() throws WSNotificationException {
    	return new UnsubscribeResponseImpl(this.wsnbFactory.createUnsubscribeResponse(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createRenew()
     */
    @Override
    public Renew createRenew() throws WSNotificationException {   	
    	return new RenewImpl(this.wsnbFactory.createRenew(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createRenewResponse()
     */
    @Override
    public RenewResponse createRenewResponse() throws WSNotificationException {
    	return new RenewResponseImpl(this.wsnbFactory.createRenewResponse(), null);
    }
        
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createSubscriptionManagerRP()
     */
    @Override
	public SubscriptionManagerRP createSubscriptionManagerRP()
			throws WSNotificationException {
    	return new SubscriptionManagerRPImpl(this.wsnbFactory.createSubscriptionManagerRP() ,null); 
	}

    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicExpressionType()
     */
    @Override
    public TopicExpressionType createTopicExpressionType()
    		throws WSNotificationException {
    	return new TopicExpressionTypeImpl(this.wsnbFactory.createTopicExpressionType(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicExpressionType(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType)
     */
    @Override
    public JAXBElement<?> createTopicExpressionType(TopicExpressionType value)
    		throws WSNotificationException {
    	// TODO Auto-generated method stub
    	return this.wsnbFactory.createTopicExpression((com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) ((AbstractSchemaElementImpl<?>)value).getModel());
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createQueryExpressionType()
     */
    @Override
    public QueryExpressionType createQueryExpressionType()
    		throws WSNotificationException {
    	return new QueryExpressionTypeImpl(this.wsnbFactory.createQueryExpressionType(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createMessageContent(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType)
     */
    @Override
    public JAXBElement<?> createMessageContent(QueryExpressionType value)
    		throws WSNotificationException {
    	return this.wsnbFactory.createMessageContent((com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType) ((AbstractSchemaElementImpl<?>)value).getModel());
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createNotificationMessageHolderType()
     */
    @Override
    public NotificationMessageHolderType createNotificationMessageHolderType()
    		throws WSNotificationException {    
    	return new NotificationMessageHolderTypeImpl(this.wsnbFactory.createNotificationMessageHolderType(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createMessage()
     */
    @Override
    public Message createMessage() throws WSNotificationException {
    	return new NotificationMessageHolderTypeImpl.MessageImpl(this.wsnbFactory.createNotificationMessageHolderTypeMessage(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createFiltertype()
     */
    @Override
    public FilterType createFiltertype() throws WSNotificationException {
    	return new FilterTypeImpl(this.wsnbFactory.createFilterType(),null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createSubscriptionPolicyType()
     */
   	@Override
	public SubscriptionPolicyType createSubscriptionPolicyType()
		throws WSNotificationException {
		return new SubscriptionPolicyTypeImpl(this.wsnbFactory.createSubscriptionPolicyType(),null);
	}
    

    // ~~~ Specific WS-BaseNotification faults part ~~~ 
    

   	/*
   	 * (non-Javadoc)
   	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidTopicExpressionFaultType()
   	 */
	@Override
	public InvalidTopicExpressionFaultType createInvalidTopicExpressionFaultType()
			throws WSNotificationException {
		//return this.wsnbFactory.createInvalidTopicExpressionFaultType();
		return new InvalidTopicExpressionFaultTypeImpl(this.wsnbFactory.createInvalidTopicExpressionFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidTopicExpressionFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidTopicExpressionFaultType)
	 */
	@Override
	public JAXBElement<?> createInvalidTopicExpressionFault(
			InvalidTopicExpressionFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createInvalidTopicExpressionFault((com.ebmwebsourcing.wsstar.notification.definition.base.InvalidTopicExpressionFaultType)((AbstractSchemaElementImpl<?>)fault).getModel());		
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicNotSupportedFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicNotSupportedFaultType)
	 */
	@Override
	public JAXBElement<?> createTopicNotSupportedFault(
			TopicNotSupportedFaultType fault) throws WSNotificationException {
		return this.wsnbFactory.createTopicNotSupportedFault((com.ebmwebsourcing.wsstar.notification.definition.base.TopicNotSupportedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicNotSupportedFaultType()
	 */
	@Override
	public TopicNotSupportedFaultType createTopicNotSupportedFaultType()
			throws WSNotificationException {
		return new TopicNotSupportedFaultTypeImpl(this.wsnbFactory.createTopicNotSupportedFaultType(), null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnacceptableInitialTerminationTimeFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableInitialTerminationTimeFaultType)
	 */
	@Override
	public JAXBElement<?> createUnacceptableInitialTerminationTimeFault(
			UnacceptableInitialTerminationTimeFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnacceptableInitialTerminationTimeFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableInitialTerminationTimeFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnacceptableInitialTerminationTimeFaultType()
	 */
	@Override
	public UnacceptableInitialTerminationTimeFaultType createUnacceptableInitialTerminationTimeFaultType()
			throws WSNotificationException {
		return new UnacceptableInitialTerminationTimeFaultTypeImpl(this.wsnbFactory.createUnacceptableInitialTerminationTimeFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidFilterFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidFilterFaultType)
	 */
	@Override
	public JAXBElement<?> createInvalidFilterFault(
			InvalidFilterFaultType fault) throws WSNotificationException {
		return this.wsnbFactory.createInvalidFilterFault((com.ebmwebsourcing.wsstar.notification.definition.base.InvalidFilterFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidFilterFaultType()
	 */
	@Override
	public InvalidFilterFaultType createInvalidFilterFaultType()
	
			throws WSNotificationException {
		return new InvalidFilterFaultTypeImpl(this.wsnbFactory.createInvalidFilterFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidMessageContentExpressionFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidMessageContentExpressionFaultType)
	 */
	@Override
	public JAXBElement<?> createInvalidMessageContentExpressionFault(
			InvalidMessageContentExpressionFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createInvalidMessageContentExpressionFault((com.ebmwebsourcing.wsstar.notification.definition.base.InvalidMessageContentExpressionFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidMessageContentExpressionFaultType()
	 */
	@Override
	public InvalidMessageContentExpressionFaultType createInvalidMessageContentExpressionFaultType()
			throws WSNotificationException {
		return new InvalidMessageContentExpressionFaultTypeImpl(this.wsnbFactory.createInvalidMessageContentExpressionFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidProducerPropertiesExpressionFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidProducerPropertiesExpressionFaultType)
	 */
	@Override
	public JAXBElement<?> createInvalidProducerPropertiesExpressionFault(
			InvalidProducerPropertiesExpressionFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createInvalidProducerPropertiesExpressionFault((com.ebmwebsourcing.wsstar.notification.definition.base.InvalidProducerPropertiesExpressionFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createInvalidProducerPropertiesExpressionFaultType()
	 */
	@Override
	public InvalidProducerPropertiesExpressionFaultType createInvalidProducerPropertiesExpressionFaultType()
			throws WSNotificationException {
		return new InvalidProducerPropertiesExpressionFaultTypeImpl(this.wsnbFactory.createInvalidProducerPropertiesExpressionFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createMultipleTopicsSpecifiedFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.MultipleTopicsSpecifiedFaultType)
	 */
	@Override
	public JAXBElement<?> createMultipleTopicsSpecifiedFault(
			MultipleTopicsSpecifiedFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createMultipleTopicsSpecifiedFault((com.ebmwebsourcing.wsstar.notification.definition.base.MultipleTopicsSpecifiedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createMultipleTopicsSpecifiedFaultType()
	 */
	@Override
	public MultipleTopicsSpecifiedFaultType createMultipleTopicsSpecifiedFaultType()
			throws WSNotificationException {
		return new MultipleTopicsSpecifiedFaultTypeImpl(this.wsnbFactory.createMultipleTopicsSpecifiedFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createNoCurrentMessageOnTopicFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NoCurrentMessageOnTopicFaultType)
	 */
	@Override
	public JAXBElement<?> createNoCurrentMessageOnTopicFault(
			NoCurrentMessageOnTopicFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createNoCurrentMessageOnTopicFault((com.ebmwebsourcing.wsstar.notification.definition.base.NoCurrentMessageOnTopicFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createNoCurrentMessageOnTopicFaultType()
	 */
	@Override
	public NoCurrentMessageOnTopicFaultType createNoCurrentMessageOnTopicFaultType()
			throws WSNotificationException {
		return new NoCurrentMessageOnTopicFaultTypeImpl(this.wsnbFactory.createNoCurrentMessageOnTopicFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createNotifyMessageNotSupportedFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotifyMessageNotSupportedFaultType)
	 */
	@Override
	public JAXBElement<?> createNotifyMessageNotSupportedFault(
			NotifyMessageNotSupportedFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createNotifyMessageNotSupportedFault((com.ebmwebsourcing.wsstar.notification.definition.base.NotifyMessageNotSupportedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());		
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createNotifyMessageNotSupportedFaultType()
	 */	
	@Override
	public NotifyMessageNotSupportedFaultType createNotifyMessageNotSupportedFaultType()
			throws WSNotificationException {
		return new NotifyMessageNotSupportedFaultTypeImpl(this.wsnbFactory.createNotifyMessageNotSupportedFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPauseFailedFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.PauseFailedFaultType)
	 */
	@Override
	public JAXBElement<?> createPauseFailedFault(
			PauseFailedFaultType fault) throws WSNotificationException {
		return this.wsnbFactory.createPauseFailedFault((com.ebmwebsourcing.wsstar.notification.definition.base.PauseFailedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPauseFailedFaultType()
	 */
	@Override
	public PauseFailedFaultType createPauseFailedFaultType()
	
			throws WSNotificationException {
		return new PauseFailedFaultTypeImpl(this.wsnbFactory.createPauseFailedFaultType(),null);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createResumeFailedFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.ResumeFailedFaultType)
	 */
	@Override
	public JAXBElement<?> createResumeFailedFault(
			ResumeFailedFaultType fault) throws WSNotificationException {
		return this.wsnbFactory.createResumeFailedFault((com.ebmwebsourcing.wsstar.notification.definition.base.ResumeFailedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());		
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createResumeFailedFaultType()
	 */
	@Override
	public ResumeFailedFaultType createResumeFailedFaultType()
			throws WSNotificationException {
		return new ResumeFailedFaultTypeImpl(this.wsnbFactory.createResumeFailedFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createSubscribeCreationFailedFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeCreationFailedFaultType)
	 */
	@Override
	public JAXBElement<?> createSubscribeCreationFailedFault(
			SubscribeCreationFailedFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createSubscribeCreationFailedFault((com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeCreationFailedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());		
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createSubscribeCreationFailedFaultType()
	 */
	@Override
	public SubscribeCreationFailedFaultType createSubscribeCreationFailedFaultType()
			throws WSNotificationException {
		return new SubscribeCreationFailedFaultTypeImpl(this.wsnbFactory.createSubscribeCreationFailedFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicExpressionDialectUnknownFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionDialectUnknownFaultType)
	 */
	@Override
	public JAXBElement<?> createTopicExpressionDialectUnknownFault(
			TopicExpressionDialectUnknownFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createTopicExpressionDialectUnknownFault((com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionDialectUnknownFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createTopicExpressionDialectUnknownFaultType()
	 */
	@Override
	public TopicExpressionDialectUnknownFaultType createTopicExpressionDialectUnknownFaultType()
			throws WSNotificationException {
		return new TopicExpressionDialectUnknownFaultTypeImpl(this.wsnbFactory.createTopicExpressionDialectUnknownFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToCreatePullPointFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToCreatePullPointFaultType)
	 */
	@Override
	public JAXBElement<?> createUnableToCreatePullPointFault(
			UnableToCreatePullPointFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnableToCreatePullPointFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnableToCreatePullPointFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToCreatePullPointFaultType()
	 */
	@Override
	public UnableToCreatePullPointFaultType createUnableToCreatePullPointFaultType()
			throws WSNotificationException {
		return new UnableToCreatePullPointFaultTypeImpl(this.wsnbFactory.createUnableToCreatePullPointFaultType(),null);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToDestroyPullPointFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToDestroyPullPointFaultType)
	 */
	@Override
	public JAXBElement<?> createUnableToDestroyPullPointFault(
			UnableToDestroyPullPointFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnableToDestroyPullPointFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnableToDestroyPullPointFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToDestroyPullPointFaultType()
	 */
	@Override
	public UnableToDestroyPullPointFaultType createUnableToDestroyPullPointFaultType()
			throws WSNotificationException {
		return new UnableToDestroyPullPointFaultTypeImpl(this.wsnbFactory.createUnableToDestroyPullPointFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToDestroySubscriptionFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToDestroySubscriptionFaultType)
	 */
	@Override
	public JAXBElement<?> createUnableToDestroySubscriptionFault(
			UnableToDestroySubscriptionFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnableToDestroySubscriptionFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnableToDestroySubscriptionFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToDestroySubscriptionFaultType()
	 */
	@Override
	public UnableToDestroySubscriptionFaultType createUnableToDestroySubscriptionFaultType()
			throws WSNotificationException {
		return new UnableToDestroySubscriptionFaultTypeImpl(this.wsnbFactory.createUnableToDestroySubscriptionFaultType(),null);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToGetMessagesFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToGetMessagesFaultType)
	 */
	@Override
	public JAXBElement<?> createUnableToGetMessagesFault(
			UnableToGetMessagesFaultType fault) throws WSNotificationException {
		return this.wsnbFactory.createUnableToGetMessagesFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnableToGetMessagesFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnableToGetMessagesFaultType()
	 */
	@Override
	public UnableToGetMessagesFaultType createUnableToGetMessagesFaultType()
			throws WSNotificationException {
		return new UnableToGetMessagesFaultTypeImpl(this.wsnbFactory.createUnableToGetMessagesFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnacceptableTerminationTimeFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableTerminationTimeFaultType)
	 */
	@Override
	public JAXBElement<?> createUnacceptableTerminationTimeFault(
			UnacceptableTerminationTimeFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnacceptableTerminationTimeFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnacceptableTerminationTimeFaultType()
	 */
	@Override
	public UnacceptableTerminationTimeFaultType createUnacceptableTerminationTimeFaultType()
			throws WSNotificationException {
		return new UnacceptableTerminationTimeFaultTypeImpl(this.wsnbFactory.createUnacceptableTerminationTimeFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnrecognizedPolicyRequestFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnrecognizedPolicyRequestFaultType)
	 */
	@Override
	public JAXBElement<?> createUnrecognizedPolicyRequestFault(
			UnrecognizedPolicyRequestFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnrecognizedPolicyRequestFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnrecognizedPolicyRequestFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnrecognizedPolicyRequestFaultType()
	 */
	@Override
	public UnrecognizedPolicyRequestFaultType createUnrecognizedPolicyRequestFaultType()
			throws WSNotificationException {
		return new UnrecognizedPolicyRequestFaultTypeImpl(this.wsnbFactory.createUnrecognizedPolicyRequestFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnsupportedPolicyRequestFault(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsupportedPolicyRequestFaultType)
	 */
	@Override
	public JAXBElement<?> createUnsupportedPolicyRequestFault(
			UnsupportedPolicyRequestFaultType fault)
			throws WSNotificationException {
		return this.wsnbFactory.createUnsupportedPolicyRequestFault((com.ebmwebsourcing.wsstar.notification.definition.base.UnsupportedPolicyRequestFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createUnsupportedPolicyRequestFaultType()
	 */
	@Override
	public UnsupportedPolicyRequestFaultType createUnsupportedPolicyRequestFaultType()
			throws WSNotificationException {
		return new UnsupportedPolicyRequestFaultTypeImpl(this.wsnbFactory.createUnsupportedPolicyRequestFaultType(),null);
	}
	// ==============================================
    
    // ======== WS-BrokeredNotification Part ======== 
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createRegisterPublisher()
     */
    @Override
	public RegisterPublisher createRegisterPublisher()
			throws WSNotificationException {
    	return new RegisterPublisherImpl(this.wsnbrFactory.createRegisterPublisher(),null);
	}
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createRegisterPublisherResponse()
     */
    @Override
    public RegisterPublisherResponse createRegisterPublisherResponse() throws WSNotificationException {
    	//return this.wsnbrFactory.createRegisterPublisherResponse();
    	return new RegisterPublisherResponseImpl(this.wsnbrFactory.createRegisterPublisherResponse(), null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createDestroyRegistration()
     */
    @Override
	public DestroyRegistration createDestroyRegistration()
			throws WSNotificationException {
		return new DestroyRegistrationImpl(this.wsnbrFactory.createDestroyRegistration() ,null);
	}
	
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createDestroyRegistrationResponse()
     */
    @Override
    public DestroyRegistrationResponse createDestroyRegistrationResponse()
    		throws WSNotificationException {
    	//return this.wsnbrFactory.createDestroyRegistrationResponse();
    	return new DestroyRegistrationResponseImpl(this.wsnbrFactory.createDestroyRegistrationResponse(), null);
    }
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPublisherRegistrationRP()
     */
    @Override
	public PublisherRegistrationRP createPublisherRegistrationRP()
			throws WSNotificationException {
		//return this.wsnbrFactory.createPublisherRegistrationRP();
    	return new PublisherRegistrationRPImpl(this.wsnbrFactory.createPublisherRegistrationRP(),null);
	}

    // ~~~ Specific WS-BrokeredNotification faults part ~~~
    
    /*
     * (non-Javadoc)
     * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPublisherRegistrationRejectedFault(com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRejectedFaultType)
     */
	@Override
	public JAXBElement<?> createPublisherRegistrationRejectedFault(
			PublisherRegistrationRejectedFaultType fault)
			throws WSNotificationException {
		return this.wsnbrFactory.createPublisherRegistrationRejectedFault((com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRejectedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPublisherRegistrationRejectedFaultType()
	 */
	@Override
	public PublisherRegistrationRejectedFaultType createPublisherRegistrationRejectedFaultType()
			throws WSNotificationException {
		return new PublisherRegistrationRejectedFaultTypeImpl(this.wsnbrFactory.createPublisherRegistrationRejectedFaultType(),null);		
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPublisherRegistrationFailedFault(com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationFailedFaultType)
	 */
	@Override
	public JAXBElement<?> createPublisherRegistrationFailedFault(
			PublisherRegistrationFailedFaultType fault)
			throws WSNotificationException {
		return this.wsnbrFactory.createPublisherRegistrationFailedFault((com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationFailedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createPublisherRegistrationFailedFaultType()
	 */
	@Override
	public PublisherRegistrationFailedFaultType createPublisherRegistrationFailedFaultType()
			throws WSNotificationException {
		return new PublisherRegistrationFailedFaultTypeImpl(this.wsnbrFactory.createPublisherRegistrationFailedFaultType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createResourceNotDestroyedFault(com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.ResourceNotDestroyedFaultType)
	 */
	@Override
	public JAXBElement<?> createResourceNotDestroyedFault(
			ResourceNotDestroyedFaultType fault) throws WSNotificationException {
		return this.wsnbrFactory.createResourceNotDestroyedFault((com.ebmwebsourcing.wsstar.notification.definition.brokered.ResourceNotDestroyedFaultType) ((AbstractSchemaElementImpl<?>)fault).getModel());
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory#createResourceNotDestroyedFaultType()
	 */
	@Override
	public ResourceNotDestroyedFaultType createResourceNotDestroyedFaultType()
			throws WSNotificationException {
		return new ResourceNotDestroyedFaultTypeImpl(this.wsnbrFactory.createResourceNotDestroyedFaultType(),null);
	}	
    // =======================================================    
}
