/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class FilterTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.FilterType> implements FilterType {

	private static final long serialVersionUID = 1L;

	public FilterTypeImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.FilterType model, final AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
	}

	public TopicExpressionType getTopicExpression() throws WSNotificationException {

		final List<Object> list = this.model.getAny();

		TopicExpressionType currentTopExp = null;

		if (list != null) {
			for (final Object item : list) {
				if (item instanceof JAXBElement<?> && ((JAXBElement<?>) item).getValue() instanceof com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) {

					final com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType topExpModel = (com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) ((JAXBElement<?>) item).getValue();

					currentTopExp = new TopicExpressionTypeImpl(topExpModel, this);

					final Map<QName, String> objFromModel = topExpModel.getOtherAttributes();
					final Set<QName> nsSet = objFromModel.keySet();

					if (nsSet != null) {
						for (final QName nameItem : nsSet) {
							currentTopExp.addTopicNameSpace(nameItem.getLocalPart(), nameItem.getNamespaceURI());
						}
					}
				}
			}
		}
		return currentTopExp;
	}

	public void setTopicExpression(final TopicExpressionType topicExpr) throws WSNotificationException {
		((AbstractSchemaElementImpl) topicExpr).setParent(this);

		final List<Object> anyFromModel = this.model.getAny();
		if (anyFromModel != null) {
			anyFromModel.add(WSNotificationFactory.getInstance().createTopicExpressionType(topicExpr));
		}
	}

	public List<QueryExpressionType> getMessageContentList() throws WSNotificationException {
		final List<QueryExpressionType> msgContent = new ArrayList<QueryExpressionType>();
		final List<Object> list = this.model.getAny();
		if (list != null) {
			for (final Object item : list) {
				if (item instanceof JAXBElement<?> && ((JAXBElement<?>) item).getValue() instanceof com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType) {
					final com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType topExpModel = (com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType) ((JAXBElement<?>) item).getValue();
					msgContent.add(new QueryExpressionTypeImpl(topExpModel, this));
				}
			}
		}
		return msgContent;
	}

	public void addMessageContent(final QueryExpressionType messageContent) throws WSNotificationException {
		((AbstractSchemaElementImpl) messageContent).setParent(this);

		final List<Object> anyFromModel = this.model.getAny();
		if (anyFromModel != null) {
			anyFromModel.add(WSNotificationFactory.getInstance().createMessageContent(messageContent));
		}
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
