package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.List;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class GetCurrentMessageResponseImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse>
		implements GetCurrentMessageResponse {
	
	private static final long serialVersionUID = 1L;
	
	public GetCurrentMessageResponseImpl(com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse model, 
			AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse#getNotifMessageContent()
	 */
	public Message getNotifMessageContent() throws WSNotificationException {
		
		Message result = null;

		final List<Object> listOfObj = 
			((com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse) ((AbstractSchemaElementImpl<?>) this).getModel()).getAny(); 			

		if (listOfObj!= null) {
			for (final Object item : listOfObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnbConstants.MESSAGE_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnbConstants.MESSAGE_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(WsnbConstants.WS_BASE_NOTIFICATION_NAMESPACE_URI);

					result = WSNotificationReader.getInstance().readMessageType(doc);
				}
				else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnbConstants.MESSAGE_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message) ) {														
					result = new NotificationMessageHolderTypeImpl.MessageImpl((com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message)((JAXBElement<?>)item).getValue(),null);					
				}				
			}
		}		

		return result;
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse#setNotifMessageContent(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message)
	 */
	public void setNotifMessageContent(Message notifMsgContent) throws WSNotificationException {
		
		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse)
					((AbstractSchemaElementImpl<?>)this).getModel()).getAny();
		if (listObj!= null){
			final Element messageAsElt = WSNotificationWriter.getInstance().writeMessageType(notifMsgContent).getDocumentElement();
			listObj.add(messageAsElt);
		}
	}
		
}
